% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressFewContributors.R
\name{SuppressFewContributors}
\alias{SuppressFewContributors}
\title{Few contributors suppression}
\usage{
SuppressFewContributors(
  data,
  maxN,
  numVar = NULL,
  dimVar = NULL,
  hierarchies = NULL,
  formula = NULL,
  contributorVar = NULL,
  removeCodes = character(0),
  remove0 = TRUE,
  candidatesVar = NULL,
  ...,
  spec = PackageSpecs("fewContributorsSpec")
)
}
\arguments{
\item{data}{Input data as a data frame}

\item{maxN}{Suppression parameter. Cells with frequency \verb{<= maxN} are set as primary suppressed.
Using the default \code{primary} function, \code{maxN} is by default set to \code{3}. See details.}

\item{numVar}{Numerical variable to be aggregated.
Any \code{candidatesVar} that is specified and
not included in \code{numVar} will be aggregated accordingly.
Additionally, if \code{remove0} is specified as a variable name and it is
not included in \code{numVar}, it will also be aggregated accordingly.
See parameters \code{candidatesVar} and \code{remove0} below.}

\item{dimVar}{The main dimensional variables and additional aggregating variables. This parameter can be  useful when hierarchies and formula are unspecified.}

\item{hierarchies}{List of hierarchies, which can be converted by \code{\link[SSBtools]{AutoHierarchies}}.
Thus, the variables can also be coded by \code{"rowFactor"} or \code{""}, which correspond to using the categories in the data.}

\item{formula}{A model formula}

\item{contributorVar}{Extra variables to be used as grouping elements when counting contributors.
Typically, the variable contains the contributor IDs.}

\item{removeCodes}{Vector of codes to be omitted when counting contributors.
With empty \code{contributorVar} row indices are assumed
and conversion to integer is performed.}

\item{remove0}{When set to \code{TRUE} (default), data rows in which the first \code{numVar} (if any) is zero
are excluded from the count of contributors.
Alternatively, \code{remove0} can be specified as one or more variable names.
In this case, all data rows with a zero in any of the specified variables
are omitted from the contributor count.
Specifying \code{remove0} as variable name(s) is useful for avoiding warning when there
are multiple \code{numVar} variables.}

\item{candidatesVar}{Variable to be used in the candidate function to prioritize cells for
publication and thus not suppression.
The first \code{numVar} variable will be used if it is not specified.}

\item{...}{Further arguments to be passed to the supplied functions and to \code{\link[SSBtools]{ModelMatrix}} (such as \code{inputInOutput} and \code{removeEmpty}).}

\item{spec}{\code{NULL} or a named list of arguments that will act as default values.}
}
\value{
data.frame containing aggregated data and supppression information.
Columns \code{nRule} and \code{nAll} contain the number of contributors.
In the former, \code{removeCodes} is taken into account.
}
\description{
This function provides functionality for suppressing volume tables based on
the few contributors rule (\code{\link{NContributorsRule}}).
}
\examples{
num <- c(100,
         90, 10,
         80, 20,
         70, 30,
         50, 25, 25,
         40, 20, 20, 20,
         25, 25, 25, 25)
v1 <- c("v1",
        rep(c("v2", "v3", "v4"), each = 2),
        rep("v5", 3),
        rep(c("v6", "v7"), each = 4))
sweight <- c(1, 2, 1, 2, 1, 2, 1, 2, 1, 1, 2, 1, 1, 1, 2, 1, 1, 1)
d <- data.frame(v1 = v1, num = num, sweight = sweight)

SuppressFewContributors(d, formula = ~v1, maxN = 1, numVar = "num")
SuppressFewContributors(d, formula = ~v1, maxN = 2, numVar = "num")
SuppressFewContributors(d, formula = ~v1, maxN = 3, numVar = "num")


d2 <- SSBtoolsData("d2")[-5]
set.seed(123)
d2$v <- round(rnorm(nrow(d2))^2, 1)
d2$family_id <- round(2*as.integer(factor(d2$region)) + runif(nrow(d2)))

# Hierarchical region variables are detected automatically -> same output column
SuppressFewContributors(data = d2, maxN = 2, numVar = "v", contributorVar = "family_id",
                      dimVar = c("region", "county", "k_group"))

# Formula. Hierarchical variables still detected automatically.
# And codes 1:9 not counted 
SuppressFewContributors(data = d2, maxN = 1, numVar = "v", contributorVar = "family_id",
                      formula = ~main_income * k_group + region + county - k_group,
                      removeCodes = 1:9)

# With hierarchies created manually
ml <- data.frame(levels = c("@", "@@", "@@@", "@@@", "@@@", "@@"), 
        codes = c("Total", "not_assistance", "other", "pensions", "wages", "assistance"))
SuppressFewContributors(data = d2, maxN = 2, numVar = "v", contributorVar = "family_id",
                      hierarchies = list(main_income = ml, k_group = "Total_Norway"))
                      
                      
}
