% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/S3methods_GeDSboost-GeDSgam.R
\name{coef.GeDSboost,gam}
\alias{coef.GeDSboost,gam}
\alias{coef.GeDSboost}
\alias{coef.GeDSboost,}
\alias{coef.GeDSgam}
\alias{coefficients.GeDSboost}
\alias{coefficients.GeDSgam}
\title{Coef method for GeDSboost, GeDSgam}
\usage{
\method{coef}{GeDSboost}(object, n = 3L, ...)

\method{coefficients}{GeDSboost}(object, n = 3L, ...)

\method{coef}{GeDSgam}(object, n = 3L, ...)

\method{coefficients}{GeDSgam}(object, n = 3L, ...)
}
\arguments{
\item{object}{the \code{\link{GeDSboost-class}} or
\code{\link{GeDSgam-class}} object from which the coefficients should be
extracted.}

\item{n}{integer value (2, 3 or 4) specifying the order (\eqn{=} degree
\eqn{ + 1}) of the FGB-GeDS/GAM-GeDS fit whose coefficients should be
extracted. 
\itemize{
 \item If \code{n = 2L} the piecewise polynomial coefficients of the univariate
 GeDS base-learners are provided. For bivariate GeDS base-learners, and if
  \code{class(object) == "GeDSboost"}, the B-spline coefficients for each
 iteration where the corresponding bivariate base-learner was selected are
 provided. For bivariate base-learners, and if
  \code{class(object) == "GeDSgam"}, the final local-scoring B-spline
  coefficients are provided.
  \item If \code{n = 3L} or \code{n = 4L} B-spline coefficients are provided
 for both univariate and bivariate GeDS learners.
}
By default \code{n} is equal to \code{3L}. Non-integer values will be passed
to the function \code{\link{as.integer}}.}

\item{...}{potentially further arguments (required by the definition of the
generic function). These will be ignored, but with a warning.}
}
\value{
A named vector containing the required coefficients of the fitted
multivariate predictor model.
}
\description{
Methods for the functions \code{\link[stats]{coef}} and
\code{\link[stats]{coefficients}} that allow to extract the estimated
coefficients of a \code{\link{GeDSboost-class}} or \code{\link{GeDSgam-class}}
object.
}
\seealso{
\code{\link[stats]{coef}} for the standard definition;
\code{\link{NGeDSboost}} and \code{\link{NGeDSgam}} for examples.
}
