% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.statistics.R
\name{graph.statistics}
\alias{graph.statistics}
\title{Point sample and statistics for edges (lines)}
\usage{
graph.statistics(x, r, d = 30, stats = c("min", "mean", "max"),
  sp = FALSE, ...)
}
\arguments{
\item{x}{sp class SpatialLinesDataFrame object}

\item{r}{A rasterLayer, rasterStack or rasterBrick object}

\item{d}{Sample distance along edge, for alternate sampline options see sample.line.}

\item{stats}{Statistics to calculate. If vectorized, can pass a custom statistic function.}

\item{sp}{Include an sp class SpatialPointsDataFrame object of the line point samples (FALSE/TRUE)}

\item{...}{Additional argument passed to sample.line and spsample}
}
\value{
data.frame object unless sp=TRUE then, list with data.frame of statistics and SpatialPointsDataFrame contaning point sample data for edges
}
\description{
Samples rasters for each edge and calculates specified statistics
}
\examples{
\dontrun{
library(sp)
library(spdep)
library(raster)
  data(rasters)
  data(ralu.site)

xvars <- stack(rasters)

dist.graph <- knn.graph(ralu.site, row.names = ralu.site@data[,"SiteName"], 
                        max.dist = 1500)
  str(dist.graph@data)
  
skew <- function(x, na.rm = TRUE) {  
          if (na.rm) x <- x[!is.na(x)]
          sum( (x - mean(x)) ^ 3) / ( length(x) * sd(x) ^ 3 )  
		}
		
stats <- graph.statistics(dist.graph, r = xvars, d=30, 
            stats = c("min", "median", "max", "var", "skew"),
            sp = FALSE) 
			
dist.graph@data <- data.frame(dist.graph@data, stats)
  str(dist.graph@data)
}

}

