% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gravity.R
\name{gravity}
\alias{gravity}
\title{Gravity model}
\usage{
gravity(y, x, d, group, data, ln = TRUE, constrained = TRUE, ...)
}
\arguments{
\item{y}{Name of dependent variable}

\item{x}{Character vector of independent variables}

\item{d}{Name of column contaning distance}

\item{group}{Name of grouping column (from or to)}

\item{data}{data.frame object containing model data}

\item{ln}{Natural log transform data (TRUE/FALSE)}

\item{constrained}{Specify constrained model, if FALSE a linear model (lm) is run (TRUE/FALSE)}

\item{...}{Additional argument passed to nlme or lm}
}
\value{
formula         Model formula

gravity         Gravity model

AIC             AIC value for selected model

x               data.frame of independent variables

y               Vector of dependent variable

groups          Ordered factor vector of grouping variable

fit             Model Fitted Values
}
\description{
Implements Murphy et al., (2010) gravity model
}
\note{
The "group" factor defines the singly constrained direction (from or to) and the grouping structure for the origins.

Depends: nlme, lattice
}
\examples{
library(nlme)
data(ralu.model)

# Gravity	
x = c("DISTANCE", "DEPTH_F", "HLI_F", "CTI_F", "cti", "ffp")
( gm <- gravity(y = "DPS", x = x, d = "DISTANCE", group = "FROM_SITE", 
                data = ralu.model, ln = FALSE) )

# Plot gravity results
 par(mfrow=c(2,3))
   for (i in 1:6) { plot(gm, type=i) } 

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org> and Melanie Murphy <melanie.murphy@uwyo.edu>
}
\references{
Murphy, M. A. & J.S. Evans. (in prep). "GenNetIt: gravity analysis in R for landscape genetics"

Murphy M.A., R. Dezzani, D.S. Pilliod & A.S. Storfer (2010) Landscape genetics of high mountain frog metapopulations. Molecular Ecology 19(17):3634-3649
}

