% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pub_activity_plot.R
\name{pub_activity_plot}
\alias{pub_activity_plot}
\title{Visualize the publication activity for genes}
\usage{
pub_activity_plot(
g_list,
k_list,
species = "mouse",
output_dir = NULL,
show_progressbar = FALSE
)
}
\arguments{
\item{g_list}{list of official gene symbols <= 30 elements.}

\item{k_list}{list of keywords <= 10 elements.}

\item{species}{selecting the species of interest (species="mouse" or species="human").}

\item{output_dir}{path to output directory to save resulting csv and png, NULL for not saving.}

\item{show_progressbar}{boolean: whether to show progress bar}
}
\value{
None
}
\description{
This function uses three input parameters, one gene list, one defined set of keywords and
species, to run a PubMed database search, and returns an annotated overview of a publication
activity plot.
}
\examples{
gene_list_mouse  = c("Mbl1")
keyword_list = c("stem cell")
pub_activity_plot(g_list = gene_list_mouse, k_list = keyword_list,
species = "mouse", output_dir=NULL,
show_progressbar=FALSE)
}
