% Generated by roxygen2 (4.0.2): do not edit by hand
\name{splineAnalyze}
\alias{splineAnalyze}
\title{Spline-based window analysis}
\usage{
splineAnalyze(Y, map, smoothness = 100, s2 = NA, mean = NA,
  plotRaw = FALSE, plotWindows = FALSE, method = 3)
}
\arguments{
\item{Y}{A vector of estimates of some parameter, such as Fst, computed at individual markers. One chromosome should be analyzed at a time.}

\item{map}{A vector of positions for each marker with a corresponding parameter estimate.}

\item{smoothness}{The level of resolution (in base pairs) for computing the spline and its derivatives}

\item{s2}{The variance of parameter estimates, to be used for computing Wstats. Default is to compute this automatically, but it may be manually specified, e.g. so that the value across chromosomes may be utilized.}

\item{mean}{The mean of parameter estimates, to be used for computing Wstats. Default is to comput this automatically, but it may be manually specified, e.g. so that the value across chromosomes may be utilized.}

\item{plotRaw}{Whether or not to produce a plot of raw data, with the fitted spline}

\item{plotWindows}{Whether or not to include a plot of Wstat values over the computed windows}

\item{method}{The method for controlling amount of smoothing: 1, 2, 3, or 4. See documentation of smooth.Pspline for description. Usual choices are either 3 for generalized cross validation or 4 for ordinary cross validation.}
}
\value{
rawSpline The fitted spline object

breaks The spline-suggested window breaks

windowData A table of mean parameter estimates and Wstats computed over spline-suggested windows
}
\description{
Defines window boundaries for analyzing genetic data and evaluates the specified windows
}
\examples{
data(chr6)
sub6 <- chr6[55000:63000,]
chr6Spline <- splineAnalyze(Y=sub6$Fst,map=sub6$Position,smoothness=100,
plotRaw=TRUE,plotWindows=TRUE,method=4)

\dontrun{
chr6Spline <- splineAnalyze(Y=chr6$Fst,map=chr6$Position,smoothness=100,
plotRaw=TRUE,plotWindows=TRUE,method=4)
}
}

