% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_marker_frequency.R
\name{calculate_marker_frequency}
\alias{calculate_marker_frequency}
\title{Calculate allele frequencies at a specific marker location}
\usage{
calculate_marker_frequency(pop, location)
}
\arguments{
\item{pop}{Population for which to estimate allele frequencies at the
given marker}

\item{location}{A vector or scalar of location(s) along the chromosome for
which allele frequencies are to be calculated. Locations are in Morgan.}
}
\value{
A tibble containing the frequency of each present ancestor at the
provided location. Ancestors with frequency = 0 are dropped out of the table.
The tibble contains three columns: location, ancestor and frequency.
}
\description{
Calculate the relative frequency of each ancestor in the
population at a specific marker location
}
\examples{
wildpop =  simulate_admixture(
   module = ancestry_module(number_of_founders = 20, morgan = 1),
   pop_size = 1000,
   total_runtime = 10)

avg_frequencies <- calculate_marker_frequency(pop = wildpop,
                                              location = 0.5)

frequencies <-
   calculate_marker_frequency(pop = wildpop,
                              location = seq(0.4, 0.5, by = 0.01))
require(ggplot2)
ggplot(frequencies, aes(x = location, y = frequency, col = ancestor)) +
  geom_step()
}
