% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_difference_frequencies.R
\name{plot_difference_frequencies}
\alias{plot_difference_frequencies}
\title{Plot the change in frequency between the start and end of a simulation}
\usage{
plot_difference_frequencies(
  results,
  picked_ancestor = "ALL",
  picked_population = 1
)
}
\arguments{
\item{results}{An object which is the result of \code{simulate_admixture}
 being a list with four properties:
\code{population}, \code{frequencies}, \code{initial_frequencies} and
\code{final frequencies}}

\item{picked_ancestor}{Default is "ALL", where different colors indicate
different ancestors. Alternatively, for clarity, the user can specify a
specific ancestral allele, and only that allele is plotted}

\item{picked_population}{If multiple populations were simulated (in the case
of \code{simulate_admixture_migration}), which population should be plotted?
Default is population_1.}
}
\value{
a ggplot2 object
}
\description{
This function plots the change in frequency of one or
multiple ancestors after performing a simulation.
}
\examples{
s <- 0.1
select_matrix <- matrix(nrow = 1, ncol = 5)
select_matrix[1, ] <- c(0.25, 1.0, 1 + 0.5 * s, 1 + s, 0)

markers <- seq(from = 0.2, to = 0.3, length.out = 100)

selected_pop <- simulate_admixture(
                    module = ancestry_module(number_of_founders = 10,
                                             morgan = 1,
                                             markers = markers),
                    pop_size = 1000,
                    total_runtime = 11,
                    select_matrix = select_matrix)
require(ggplot2)
plot_difference_frequencies(results = selected_pop,
                            picked_ancestor = "ALL")
}
