% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/GeoLight.R
\name{schedule}
\alias{schedule}
\title{Function for making a data frame summarising residency and movement pattern.}
\usage{
schedule(tFirst, tSecond, site)
}
\arguments{
\item{tFirst}{date and time of sunrise/sunset (e.g. 2008-12-01 08:30)}

\item{tSecond}{date and time of sunrise/sunset (e.g. 2008-12-01 17:30)}

\item{site}{a \code{vector}, indicating the residency period of a particular
day (see output: \code{\link{changeLight}})}
}
\value{
A \code{data.frame} with end and start date (yyyy-mm-dd hh:mm, UTC)
for each stationary period.
}
\description{
Function for making a data frame summarising residency and movement pattern.
}
\examples{
data(hoopoe2)
  hoopoe2$tFirst <- as.POSIXct(hoopoe2$tFirst, tz = "GMT")
  hoopoe2$tSecond <- as.POSIXct(hoopoe2$tSecond, tz = "GMT")
residency <- changeLight(hoopoe2, rise.prob=0.1, set.prob=0.1, plot=FALSE, summary=FALSE)
schedule(hoopoe2[,1], hoopoe2[,2], site = residency$site)
}
\author{
Simeon Lisovski
}

