% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{lon_lat_to_cartesian}
\alias{lon_lat_to_cartesian}
\title{Convert Geographic Coordinates to Cartesian Coordinates}
\usage{
lon_lat_to_cartesian(lon, lat, R = 6371)
}
\arguments{
\item{lon}{Numeric vector of longitudes in degrees.}

\item{lat}{Numeric vector of latitudes in degrees.}

\item{R}{Radius of the Earth in kilometers (default: 6371 km).}
}
\value{
A numeric matrix with three columns (x, y, z) representing Cartesian coordinates.
}
\description{
This function converts geographic coordinates, given as longitude and latitude in degrees, to Cartesian coordinates (x, y, z) assuming a spherical Earth model.
}
\examples{
lon <- c(-122.4194, 0)
lat <- c(37.7749, 0)
lon_lat_to_cartesian(lon, lat)
}
