% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentiment_analysis.R
\name{average_book_sentiment}
\alias{average_book_sentiment}
\title{Calculate average sentiment score per book}
\usage{
average_book_sentiment(sentiment_df)
}
\arguments{
\item{sentiment_df}{A data frame containing the output from analyze_sentiment.}
}
\value{
A data frame with average sentiment scores for each book.
}
\description{
This function calculates the average sentiment score for each book.
}
\examples{
\donttest{
# Create a temporary file with sample book IDs
temp_file <- tempfile(fileext = ".txt")
writeLines(c("1420", "2767052", "10210"), temp_file)

# Run the scrape_reviews function
reviews <- scrape_reviews(temp_file, num_reviews = 5, use_parallel = FALSE)

# Check if reviews were successfully scraped
if (nrow(reviews) > 0) {
  # Perform sentiment analysis
  sentiment_results <- analyze_sentiment(reviews, lexicon = "afinn")

  # Calculate average sentiment score per book
  avg_senti <- average_book_sentiment(sentiment_results)

  # Display the results
  print(avg_senti)
} else {
  cat("No reviews found. Cannot calculate average sentiment.\n")
}

# Clean up: remove the temporary file
file.remove(temp_file)
}
}
