% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ordering_functions.R
\name{order_dist_to_point}
\alias{order_dist_to_point}
\title{Distance to specified point ordering}
\usage{
order_dist_to_point(locs, loc0, lonlat = FALSE)
}
\arguments{
\item{locs}{A matrix of locations. Each row of \code{locs} contains a location, which can
be a point in Euclidean space R^d, a point in space-time R^d x T, 
a longitude and latitude (in degrees) giving a point on the sphere, 
or a longitude, latitude, and time giving a point in the sphere-time domain.}

\item{loc0}{A vector containing a single location in R^d.}

\item{lonlat}{TRUE/FALSE whether locations are longitudes and latitudes.}
}
\value{
A vector of indices giving the ordering, i.e. 
the first element of this vector is the index of the location nearest to \code{loc0}.
}
\description{
Return the ordering of locations increasing in their
distance to some specified location
}
\examples{
n <- 100             # Number of locations
d <- 2               # dimension of domain
locs <- matrix( runif(n*d), n, d )
loc0 <- c(1/2,1/2)
ord <- order_dist_to_point(locs,loc0)
}
