% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/greedy_orthogonalization_curation.R
\name{greedy_orthogonalization_curation}
\alias{greedy_orthogonalization_curation}
\title{Curate More Orthogonal Vectors Greedily}
\usage{
greedy_orthogonalization_curation(W, Rmin = 2, verbose = FALSE)
}
\arguments{
\item{W}{A matrix in ${-1, 1}^{R x n}$ which have R allocation vectors for an experiment of sample size n.}

\item{Rmin}{The minimum number of vectors to consider in a design. The default is the true bottom, two.}

\item{verbose}{Default is \code{FALSE} but if not, it will print out a message for each iteration.}
}
\value{
A list with two elements: (1) \code{avg_abs_rij_by_R} which is a data frame with R - Rmin + 1 rows and 
					columns R and average absolute r_ij and (2) \code{Wsorted} which provides the collection of vectors in
					sorted by best average absolute r_ij in row order from best to worst.
}
\description{
This function takes a set of allocation vectors and pares them down one-by-one
by eliminating the vector that can result in the largest reduction in Avg[ |r_ij| ].
It is recommended to begin with a set of unmirrored vectors for speed. Then add the mirrors later
for whichever subset you wish.
}
\author{
Adam Kapelner
}
