package de.fhg.iais.kd.djm;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;

import org.apache.log4j.Logger;

public class FileTransfer {
	private static Logger logger = Logger.getLogger(ClientConnection.class);
	
	
	/**
	 * 
	 * @param inputFiles
	 * @param downloadDir
	 * @param fis
	 * @throws IOException
	 */
	public static void downloadFilesTo(ArrayList<InputFile> inputFiles, String downloadDir, DataInputStream fis) throws IOException {

		if(!(downloadDir.startsWith("/") || downloadDir.startsWith("\\") || downloadDir.substring(1, 2).equals(":")))
			downloadDir = System.getProperty("user.home") + "/" + downloadDir;
		if(!new File(downloadDir).isDirectory()){
			new File(downloadDir).mkdirs();
		}
		for(InputFile inputFile : inputFiles){
			try{
				logger.debug("Downloading file " + inputFile.getFilename() + ":" + inputFile.getSize() + " to " + downloadDir);
	
				long size = inputFile.getSize();
				FileOutputStream fos = new FileOutputStream(downloadDir + "/" + new File(inputFile.filename).getName());
				byte[] b = new byte[1024];
				long transfered =0;
				while(transfered<size)
				{
					int bytes=0;
					int rest = (int)(size - transfered);
					if(rest>=1024){
						//try to read 1024 bytes from socket
						bytes = fis.read(b);
						if(bytes<=0){
							throw(new IOException("cannot read from socket. missing:" + (size - transfered) + " needed: " + size + " read: " + bytes));
						}
						if(bytes==1024)
						{
							fos.write(b);
						}
						else{
							//can only read "bytes" bytes from socket
							byte[] b2 = new byte[bytes];
							System.arraycopy(b, 0, b2, 0, bytes);
							fos.write(b2);
						}
					}
					else{
						//read less than 1024 bytes from socket, because file size is reached after that
						byte[] b2 = new byte[rest];
						bytes = fis.read(b2);
						
						if(bytes==rest)
						{
							fos.write(b2);
						}
						else{
							//can only read "bytes" bytes from socket
							byte[] b3 = new byte[bytes];
							System.arraycopy(b2, 0, b3, 0, bytes);
							fos.write(b2);
						}
					}
					transfered+=bytes;
					//System.err.println("writing " + bytes + " bytes to " + remoteDir + "/" + inputFile.filename);
				}
				fos.close();
			} catch(Exception e){
				logger.error("cannot save File " + downloadDir + "/" + new File(inputFile.filename).getName()+"\n" + e.getMessage());
			}
			
		}
		fis.close();
	}
	
	/**
	 * 
	 * @param ip
	 * @param port
	 * @param inputFiles
	 * @param username
	 * @throws IOException
	 */
	public static void uploadFiles(DataOutputStream fos,  ArrayList<InputFile> inputFiles, String username) throws IOException{
		for(InputFile inputFile : inputFiles){
			try{
				System.out.println(("uploading file "+ inputFile.getFilename()));
				long size = new File(inputFile.getFilename()).length();
				FileInputStream fis = new FileInputStream(inputFile.getFilename());
				byte[] b = new byte[1024];
				long transfered =0;
				while(transfered<size)
				{
					
					int bytes = fis.read(b);
					if(bytes<=0){
						throw(new IOException("cannot read from file. missing:" + (size - transfered) + " needed: " + size + " read: " + bytes));
					}
					if(bytes==1024)
						fos.write(b);
					else{
						//cannot read the full 1024 bytes, because filezize is reached
						byte[] b2 = new byte[bytes];
						System.arraycopy(b, 0, b2, 0, bytes);
						fos.write(b2);
						System.err.println("Rest of transferring is: " + bytes);
					}
					transfered+=bytes;
					//System.err.println("writing " + bytes + " bytes to " + remoteDir + "/" + inputFile.filename);
				}
				fis.close();
				System.out.println("wrote " + transfered + " bytes to socket");
			} catch(Exception e){
				logger.error("cannot upload file " + inputFile.getFilename() +"\n" + e.getMessage());
			}
		}
		fos.close();
	}

	public static ArrayList<InputFile> setFileSizesAndSend(DataOutputStream fos,  ArrayList<InputFile> inputFiles) throws IOException{
		String sizes = "";
		for(int i=0; i < inputFiles.size();i++){
			InputFile inputFile = inputFiles.get(i);
			long size = new File(inputFile.getFilename()).length();
			inputFile.size = size;
			sizes += size + " ";
			inputFiles.set(i, inputFile);
		}
		fos.writeChars(sizes.substring(0, sizes.length()-1)+ "\n");
		return inputFiles;
	}
	public static ArrayList<InputFile> receiveSizesAndSave(DataInputStream fis, ArrayList<InputFile> inputFiles) throws IOException{
		String line="";
		try{
			char c = 0;
			boolean contin=true;
			while(contin && (c=fis.readChar())>=0){
				if(c!='\n'){
					line+=c;
				}
				else{
					//line equals 222 33 33 fileSizes for each file
					String[] sizes = line.split(" ");
					if(sizes.length!= inputFiles.size()){
						logger.error("wrong size of  received number of sizes: it is " + sizes.length + " inputFiles size is " + inputFiles.size());
						return null;
					}
					for(int i=0; i < inputFiles.size();i++){
						InputFile inputFile = inputFiles.get(i);
						inputFile.size = new Long(sizes[i]);
						inputFiles.set(i, inputFile);
					line="";
					contin=false;
				}		
			}
				
		}
		}catch (Exception e){
			System.err.println(line);
			logger.error("Cannot receive and set inputFile sizes " + e.getMessage());
			e.printStackTrace();
			return null;
		}
		return inputFiles;
	}

}
