% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWEIS_quantitative.R
\name{GWEIS_quantitative}
\alias{GWEIS_quantitative}
\title{GWEIS_quantitative function
This function performs GWEIS using plink2 and outputs the GWEIS summary statistics with additive SNP effects and interaction SNP effects separately. It is recommended to save the outputs in separate user-specified files (see examples).}
\usage{
GWEIS_quantitative(
  plink_path,
  b_file,
  Qphe_discovery,
  Qcov_discovery,
  thread = 20
)
}
\arguments{
\item{plink_path}{Path to the PLINK executable application}

\item{b_file}{Prefix of the binary files, where all .fam, .bed and .bim files have a common prefix}

\item{Qphe_discovery}{Phenotype file containing family ID, individual ID and phenotype of the discovery dataset as columns, without heading}

\item{Qcov_discovery}{Covariate file containing family ID, individual ID, standardized covariate, square of standardized covariate, and/or confounders of the discovery dataset as columns, without heading}

\item{thread}{Number of threads used}
}
\value{
This function will perform GWEIS and output
\item{Q_out.sum}{GWEIS summary statistics with additive and interaction SNP effects}
}
\description{
GWEIS_quantitative function
This function performs GWEIS using plink2 and outputs the GWEIS summary statistics with additive SNP effects and interaction SNP effects separately. It is recommended to save the outputs in separate user-specified files (see examples).
}
\examples{
\dontrun{ 
x <- GWEIS_quantitative (plink_path, DummyData, Qphe_discovery, Qcov_discovery, 
thread = 20)
sink("Q_out.add.sum") #to create a file in the working directory
write.table(x[c("ID", "A1", "ADD_BETA")], sep = " ", 
row.names = FALSE, quote = FALSE) #to write the output
sink() #to save the output
sink("Q_out.gxe.sum") #to create a file in the working directory
write.table(x[c("ID", "A1", "INTERACTION_BETA")], sep = " ", 
row.names = FALSE, quote = FALSE) #to write the output
sink() #to save the output
head(x) #to extract the head of all columns in GWEIS summary  
#statistics of additive and interaction SNP effects 
x$CHROM #to extract the chromosome number 
x$POS #to extract the base pair position
x$ID #to extract the SNP ID
x$REF #to extract the reference allele
x$ALT #to extract the alternate allele 
x$A1 #to extract the minor allele
x$OBS_CT #to extract the number of allele observations 
x$ADD_BETA #to extract the additive SNP effects
x$ADD_SE #to extract the standard errors of the 
#additive SNP effects
x$ADD_T_STAT #to extract the test statistics of additive 
#SNP effects
x$ADD_P #to extract the p values of additive SNP effects
x$INTERACTION_BETA #to extract the interaction SNP effects
x$INTERACTION_SE #to extract the standard errors of the 
#interaction SNP effects
x$INTERACTION_T_STAT #to extract the test statistics of 
#interaction SNP effects
x$INTERACTION_P #to extract the p values of interaction 
#SNP effects
}
}
\keyword{gweis}
\keyword{gxe}
\keyword{interaction}
