% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GWEIS_binary.R
\name{GWEIS_binary}
\alias{GWEIS_binary}
\title{GWEIS_binary function
This function performs GWEIS using plink2 and outputs the GWEIS summary statistics with additive SNP effects and interaction SNP effects. Users may save the outputs in separate user-specified files (see examples).}
\usage{
GWEIS_binary(plink_path, b_file, Bphe_discovery, Bcov_discovery, thread = 20)
}
\arguments{
\item{plink_path}{Path to the PLINK executable application}

\item{b_file}{Prefix of the binary files, where all .fam, .bed and .bim files have a common prefix}

\item{Bphe_discovery}{Phenotype file containing family ID, individual ID and phenotype of the discovery dataset as columns, without heading}

\item{Bcov_discovery}{Covariate file containing family ID, individual ID, standardized covariate, square of standardized covariate, and/or confounders of the discovery dataset as columns, without heading}

\item{thread}{Number of threads used}
}
\value{
This function will perform GWEIS and output
\item{B_out.sum}{GWEIS summary statistics with additive and interaction SNP effects}
}
\description{
GWEIS_binary function
This function performs GWEIS using plink2 and outputs the GWEIS summary statistics with additive SNP effects and interaction SNP effects. Users may save the outputs in separate user-specified files (see examples).
}
\examples{
\dontrun{ 
x <- GWEIS_binary(plink_path, DummyData, Bphe_discovery, Bcov_discovery, 
thread = 20)
sink("B_out.add.sum") #to create a file in the working directory
write.table(x[c("ID", "A1", "ADD_OR")], sep = " ", 
row.names = FALSE, quote = FALSE) #to write the output
sink() #to save the output
sink("B_out.gxe.sum") #to create a file in the working directory
write.table(x[c("ID", "A1", "INTERACTION_OR")], sep = " ", 
row.names = FALSE, quote = FALSE) #to write the output
sink() #to save the output
head(x) #to extract the head of all columns in GWEIS summary  
#statistics of additive and interaction SNP effects 
x$CHROM #to extract the chromosome number 
x$POS #to extract the base pair position
x$ID #to extract the SNP ID
x$REF #to extract the reference allele
x$ALT #to extract the alternate allele 
x$A1 #to extract the minor allele
x$OBS_CT #to extract the number of allele observations 
x$ADD_OR #to extract the odds ratios of additive SNP effects
x$ADD_LOG_OR_SE #to extract the standard errors of log  
#odds of additive SNP effects
x$ADD_Z_STAT #to extract the test statistics of additive 
#SNP effects
x$ADD_P #to extract the p values of additive SNP effects
x$INTERACTION_OR #to extract the odds ratios of  
#interaction SNP effects
x$INTERACTION_LOG_OR_SE #to extract the standard errors of  
#log odds of interaction SNP effects
x$INTERACTION_Z_STAT #to extract the test statistics of  
#interaction SNP effects
x$INTERACTION_P #to extract the p values of interaction 
#SNP effects
}
}
\keyword{gweis}
\keyword{gxe}
\keyword{interaction}
