% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/asca.R
\name{asca}
\alias{asca}
\title{Analysis of Variance Simultaneous Component Analysis - ASCA}
\usage{
asca(formula, data, ...)
}
\arguments{
\item{formula}{Model formula accepting a single response (block) and predictors. See Details for more information.}

\item{data}{The data set to analyse.}

\item{...}{Additional arguments to \code{\link{asca_fit}}.}
}
\value{
An \code{asca} object containing loadings, scores, explained variances, etc. The object has
associated plotting (\code{\link{asca_plots}}) and result (\code{\link{asca_results}}) functions.
}
\description{
This is a quite general and flexible implementation of ASCA.
}
\details{
ASCA is a method which decomposes a multivariate response according to one or more design
variables. ANOVA is used to split variation into contributions from factors, and PCA is performed
on the corresponding least squares estimates, i.e., \code{Y = X1 B1 + X2 B2 + ... + E = T1 P1' + T2 P2' + ... + E}.
This version of ASCA encompasses variants of LiMM-PCA, generalized ASCA and covariates ASCA. It includes
confidence ellipsoids for the balanced crossed-effect ASCA.

The formula interface is extended with the function r() to indicate random
effects and comb() to indicate effects that should be combined. See Examples
for use cases.
}
\examples{
# Load candies data
data(candies)

# Basic ASCA model with two factors
mod <- asca(assessment ~ candy + assessor, data=candies)
print(mod)

# ASCA model with interaction
mod <- asca(assessment ~ candy * assessor, data=candies)
print(mod)

# Result plotting for first factor
loadingplot(mod, scatter=TRUE, labels="names")
scoreplot(mod)
# No backprojection
scoreplot(mod, projections=FALSE)
# Spider plot
scoreplot(mod, spider=TRUE, projections=FALSE)

# ASCA model with compressed response using 5 principal components
mod.pca <- asca(assessment ~ candy + assessor, data=candies, pca.in=5)

# Mixed Model ASCA, random assessor
mod.mix <- asca(assessment ~ candy + r(assessor), data=candies)
scoreplot(mod.mix)

# Load Caldana data
data(caldana)

# Combining effects in ASCA
mod.comb <- asca(compounds ~ time + comb(light + time:light), data=caldana)
summary(mod.comb)
timeplot(mod.comb, factor="light", time="time", comb=2)

# Permutation testing
mod.perm <- asca(assessment ~ candy * assessor, data=candies, permute=TRUE)
summary(mod.perm)

}
\references{
\itemize{
\item Smilde, A., Jansen, J., Hoefsloot, H., Lamers,R., Van Der Greef, J., and Timmerman, M.(2005). ANOVA-Simultaneous Component Analysis (ASCA): A new tool for analyzing designed metabolomics data. Bioinformatics, 21(13), 3043–3048.
\item Liland, K.H., Smilde, A., Marini, F., and Næs,T. (2018). Confidence ellipsoids for ASCA models based on multivariate regression theory. Journal of Chemometrics, 32(e2990), 1–13.
\item Martin, M. and Govaerts, B. (2020). LiMM-PCA: Combining ASCA+ and linear mixed models to analyse high-dimensional designed data. Journal of Chemometrics, 34(6), e3232.
}
}
\seealso{
Main methods: \code{\link{asca}}, \code{\link{apca}}, \code{\link{limmpca}}, \code{\link{msca}}, \code{\link{pcanova}}, \code{\link{prc}} and \code{\link{permanova}}.
Workhorse function underpinning most methods: \code{\link{asca_fit}}.
Extraction of results and plotting: \code{\link{asca_results}}, \code{\link{asca_plots}}, \code{\link{pcanova_results}} and \code{\link{pcanova_plots}}
}
