\name{HDBRR}
\alias{HDBRR}
\alias{summary.HDBRR}
\alias{print.summary.HDBRR}
\alias{print.HDBRR}
\alias{plot.HDBRR}
\alias{predict.HDBRR}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
High Dimensional Bayesian Ridge Regression without MCMC.
}
\description{
Ridge regression provide biased estimators of the regression parameters with lower variance. The HDBRR ("High Dimensional Bayesian Ridge Regression") function fits Bayesian Ridge regression without MCMC, this one uses the SVD or QR decomposition for the posterior computation.
}
\usage{
HDBRR(y, X, n0 = 5, p0 = 5, s20 = NULL, d20 = NULL, h = 0.5,
    intercept = TRUE, vpapp = TRUE,npts = NULL,c = NULL,
    corpred = NULL, method = c("svd","qr"),bigmat = TRUE, ncores = 2)

\method{summary}{HDBRR}(object, all.coef = FALSE, crit = log(4), ...)

\method{plot}{HDBRR}(x, crit = log(4), ...)

\method{predict}{HDBRR}(object,  ...)

\method{print}{summary.HDBRR}(x, ...)

\method{print}{HDBRR}(x, ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{y}{
The data vector (numeric, n) NAs allowed.
}
  \item{X}{
Design Matrix of dimension \code{n x p}.
}
  \item{n0,p0}{
\code{n0/2} and \code{p0/2} are the shape parameter of the Gamma Inverse prior assigned to the residual variance and the shape parameter of the Gamma Inverse prior assigned to the Beta's variance respectively. The default value for \code{n0/2} and \code{p0/2} parameter is 5.
}
  \item{s20,d20}{
\code{(n0s20)/2} and \code{(p0d20)/2} are the scale parameter of the Gamma Inverse prior assigned to the residual variance and the scale parameter of the Gamma Inverse prior assigned to the Beta's variance respectively. The default value for the \code{s20} and \code{d20} is \code{NULL}. If the scale is not specified a value is calculated with \code{h} and quantiles.
}
  \item{h}{
(numeric, 0<\code{h}<1) shrinkage factor. Only used if the hyper-parameters are not specified; If h -> 0 then we have greater shrinkage, this is, \eqn{\beta} -> 0. If h -> 1 then we have less shrinkage.
}
  \item{intercept}{
Logic value. The default value for the \code{intercept} is TRUE.
}
 \item{vpapp}{
Logic value. Compute an approximation of the predictive variance. The default value for the \code{vpapp} is TRUE.
}
  \item{npts}{
Number (integer) of points used to evaluate the u's density for the numeric aprroach. The default value for the \code{npts} parameter is 200.
}
  \item{c}{
ratio of Gaussian densities (Spike/Slab) in the prior mixture density of each Beta for variable selection.
}
  \item{corpred}{
The method for the compute of the correlation, there are two methods, Empirical Bayes (\code{"eb"}) and Bayesian (\code{"b"}) method. The default value for the parameter corpred is NULL. If the values is NULL then the corr and edf values will be NULL.
}
  \item{method}{
Options for the posterior computation. There are two methods available: \code{"qr"} decomposition of \code{X*t(X)} and \code{"svd"} decomposition of matrix \code{X}. The default value for the method is SVD decomposition.
}
 \item{bigmat}{
Use of the bigstatsr package. The default value for \code{bigmat} is \code{TRUE}.
}
  \item{ncores}{
Number of the cores for computation. The default value for the ncores is 2, you can detect your number of cores with \code{detectCores()} and use it (iOS and Linux).
}
 \item{object}{
    A HDBRR object, typically generated by a call to \code{HDBRR}.
  }
  \item{all.coef}{
    Logical. Should results be returned for all ridge regression penalty
    parameters (\code{all.coef = TRUE}), or only  those whose \code{log(bayes factor)>crit}.
  }
  \item{crit}{
    Numerical. The lower bound of the log Bayes factor in favour to include a variable in the model. The default value for \code{crit} is \code{log(4)}.
  }
   \item{\dots}{
    Additional arguments to be passed to or from other methods.
  }
  \item{x}{
    A HDBRR object, typically generated by a call to \code{HDBRR} (for the
    \code{print.HDBRR} and \code{plot.HDBRR} functions) or an object of class
    \code{summary.HDBRR} (for the \code{print.summary.HDBRR}
    function).
  }
}
\details{
Ridge regression is a useful tool to deal with colinerity in the homocesastic linear regression model providing biased estimators of the regression parameters with lower variance than the least square estimators.
The model \deqn{y = X\beta + \epsilon} where \eqn{\epsilon} vector is assumed Normal with mean vector 0 and covariance matrix \eqn{\sigma^2 I_n}. For further details see the vignettes in the package.
}
\value{
List containing the following components:
\item{betahat}{
Vector (numeric, \code{p})  with the betas estimates.
}
\item{yhat}{
Vector (numeric, \code{n}) with the y's estimates.
}
\item{sdyhat}{
Vector (numeric, \code{n}) with the standard deviation of the predicts values.
}
\item{sdpred}{
Vector (numeric, \code{n}) with the standard deviation of predict variances.
}
\item{varb}{
Vector (numeric, \code{p}) with the beta's variance.
}
\item{sigsqhat}{
Value (numeric) of the residual variance estimate.
}
\item{sigbsqhat}{
Value (numeric) of the Beta's variance estimate.
}
\item{u}{
Vector (numeric, \code{npts}) with the u's values.
}
\item{postu}{
Vector (numeric, \code{npts}) with the values of the u posterior.
}
\item{uhat}{
Value (numeric) of u estimated.
}
\item{umode}{
Value (numeric) of the posterior mode of u.
}
\item{whichNa}{
Value (integer) of NAs in the y vector.
}
\item{phat}{
Vector (numeric, \code{p}), selection probability of x_i.
}
\item{delta}{
Used in the variable selection.
}
\item{edf}{
Value (numeric) of the effective degrees of freedom for regression.
}
\item{corr}{
Vector (numeric, \code{n}) of the correlation between \code{y_i} estimates and \code{y_i}.
}
}

\author{
Sergio Perez-Elizalde, Blanca E. Monroy-Castillo, Paulino Perez-Rodriguez, Jose Crossa.
}

\examples{
\dontrun{

data("phenowheat")
mod <- lmer(pheno$HD~pheno$env+(1|pheno$Line))
y <- unlist(ranef(mod))
n <- length(y)
X <- scale(X, scale=F)
fitall <- HDBRR(y,X/sqrt(ncol(X)),intercept = FALSE, corpred = "eb", c = 100)
fitall
sumarry(fitall, crit = 0)
plot(fitall, crit = 0)
predict(fitall)

}
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{BRR.}% use one of  RShowDoc("KEYWORDS")
\keyword{ BRR without MCMC.}% __ONLY ONE__ keyword per line
