% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_significant_peptides.R
\name{peptide_pv_tp}
\alias{peptide_pv_tp}
\title{Preparatory function for significant peptide plots}
\usage{
peptide_pv_tp(
  df,
  pv,
  sd,
  nb_row,
  ranges = c(-Inf, seq(-30, 30, by = 10), Inf),
  pv_cutoff = 0.01,
  replicates = 3
)
}
\arguments{
\item{df}{average data frame. Generated using ave_timepoint() function.}

\item{pv}{pvalues dataframes calculated using pv_timepoint() function}

\item{sd}{standard deviation data.frame generated using sd_timepoint function}

\item{nb_row}{number of peptides in each row. Plotting parameter.}

\item{ranges}{ranges for coloring scheme. Default set to c(-Inf, seq(-30, 30, by=10), Inf)}

\item{pv_cutoff}{p-value cutoff here set up to 0.01}

\item{replicates}{number of replicates in sample. Default set to 3.}
}
\value{
plot with peptides which are significantly different between sets.
}
\description{
Returns plot where significant peptides are colored in blue-red scheme.
}
