% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustControl.R
\name{clustControl}
\alias{clustControl}
\title{Parameters for MBM clustering algorithm.}
\usage{
clustControl(minSize = 1, modeTh = 0.01, useL1norm = FALSE,
  getlikelh = FALSE)
}
\arguments{
\item{minSize}{Minimum cluster size. Clusters that contain the number of data points
smaller than \code{minSize} are merged to the closest big cluster.}

\item{modeTh}{Distance parameter that controls mode merging. Larger values 
promote merging of different clusters.}

\item{useL1norm}{A logical value indicating whether or not L1 norm will be 
used to calculate the distance.}

\item{getlikelh}{A logical value indicating whether or not to calculate the
loglikelihood for every data point.}
}
\value{
The named list with parameters.
}
\description{
This function creates a list with parameters for Modal Baum-Welch (MBW)
clustering algorithm used as an argument for \code{hmmvbClust}.
}
\examples{
# avoid clusters of size < 60
Vb <- vb(1, dim=4, numst=2)
set.seed(12345)
hmmvb <- hmmvbTrain(iris[,1:4], VbStructure=Vb)
clust <- hmmvbClust(iris[,1:4], model=hmmvb, control=clustControl(minSize=60))
show(clust)
}
\seealso{
\code{\link{hmmvbTrain}}
}
