% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGeneric.R, R/AllMethod.R
\docType{methods}
\name{getNb}
\alias{getNb}
\alias{getNb,VB-method}
\alias{getNb,HMMVB-method}
\title{Accessor for 'nb' slot}
\usage{
getNb(object)

\S4method{getNb}{VB}(object)

\S4method{getNb}{HMMVB}(object)
}
\arguments{
\item{object}{Object of class "VB" or "HMMVB".}
}
\description{
This function outputs number of blocks of the variable block structure.
}
\examples{
# accessing nb in instance of class VB
Vb <- vb(2, dim=10, bdim=c(4,6), numst=c(3,11), varorder=list(c(1:4),c(5:10)))
getNb(Vb)

# accessing nb in instance of class HMMVB 
data("sim3")
Vb <- vb(2, dim=40, bdim=c(10,30), numst=c(3,5), varorder=list(c(1:10),c(11:40)))
set.seed(12345)
hmmvb <- hmmvbTrain(sim3[,1:40], VbStructure=Vb)
getNb(hmmvb)  
    
}
