% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hima.R
\name{hima}
\alias{hima}
\title{High-dimensional Mediation Analysis}
\usage{
hima(X, Y, M, COV.XM = NULL, COV.MY = COV.XM, family = c("gaussian",
  "binomial"), penalty = c("MCP", "SCAD", "lasso"), topN = NULL,
  parallel = FALSE, ncore = 1, verbose = FALSE, ...)
}
\arguments{
\item{X}{a vector of exposure.}

\item{Y}{a vector of outcome. Can be either continuous or binary (0-1).}

\item{M}{a \code{data.frame} or \code{matrix} of high-dimensional mediators. Rows represent samples, columns 
represent variables.}

\item{COV.XM}{a \code{data.frame} or \code{matrix} of covariates dataset for testing the association \code{M ~ X}. 
Covariates specified here will not participate penalization. Default = \code{NULL}. If the covariates 
contain mixed data types, please make sure all categorical variables are properly formatted as \code{factor} type.}

\item{COV.MY}{a \code{data.frame} or \code{matrix} of covariates dataset for testing the association \code{Y ~ M}. 
Covariates specified here will not participate penalization. If not specified, the same set of covariates for 
\code{M ~ X} will be applied. Using different sets of covariates is allowed but this needs to be handled carefully.}

\item{family}{either 'gaussian' or 'binomial', depending on the data type of outcome (\code{Y}). See 
\code{\link{ncvreg}}}

\item{penalty}{the penalty to be applied to the model. Either 'MCP' (the default), 'SCAD', or 
'lasso'. See \code{\link{ncvreg}}.}

\item{topN}{an integer specifying the number of top markers from sure independent screening. 
Default = \code{NULL}. If \code{NULL}, \code{topN} will be either \code{ceiling(n/log(n))} if 
\code{family = 'gaussian'}, or \code{ceiling(n/(2*log(n)))} if \code{family = 'binomial'}, 
where \code{n} is the sample size.}

\item{parallel}{logical. Enable parallel computing feature? Default = \code{TRUE}.}

\item{ncore}{number of cores to run parallel computing Valid when \code{parallel == TRUE}. 
By default max number of cores available in the machine will be utilized.}

\item{verbose}{logical. Should the function be verbose? Default = \code{FALSE}.}

\item{...}{other arguments passed to \code{\link{ncvreg}}.}
}
\value{
A data.frame containing mediation testing results of selected mediators. 
\itemize{
    \item{alpha: }{coefficient estimates of exposure (X) --> mediators (M).}
    \item{beta: }{coefficient estimates of mediators (M) --> outcome (Y) (adjusted for exposure).}
    \item{gamma: }{coefficient estimates of exposure (X) --> outcome (Y) (total effect).}
    \item{alpha*beta: }{mediation effect.}
    \item{\% total effect: }{alpha*beta / gamma. Percentage of the mediation effect out of the total effect.}
    \item{adjusted.p: }{statistical significance of the mediator (Bonferroni procedure).}
    \item{BH.FDR: }{statistical significance of the mediator (Benjamini-Hochberg procedure).}
}
}
\description{
\code{hima} is used to estimate and test high-dimensional mediation effects.
}
\examples{
n <- 100  # sample size
p <- 500 # the dimension of covariates

# the regression coefficients alpha (exposure --> mediators)
alpha <- rep(0, p) 

# the regression coefficients beta (mediators --> outcome)
beta1 <- rep(0, p) # for continuous outcome
beta2 <- rep(0, p) # for binary outcome

# the first four markers are true mediators
alpha[1:4] <- c(0.45,0.5,0.6,0.7)
beta1[1:4] <- c(0.55,0.6,0.65,0.7)
beta2[1:4] <- c(1.45,1.5,1.55,1.6)

# these are not true mediators
alpha[7:8] <- 0.5
beta1[5:6] <- 0.8
beta2[5:6] <- 1.7

# Generate simulation data
simdat_cont = simHIMA(n, p, alpha, beta1, seed=1029) 
simdat_bin = simHIMA(n, p, alpha, beta2, binaryOutcome = TRUE, seed=1029) 

# Run HIMA with MCP penalty by default
# When Y is continuous (default)
hima.fit <- hima(simdat_cont$X, simdat_cont$Y, simdat_cont$M, verbose = TRUE) 
head(hima.fit)

# When Y is binary (should specify family)
hima.logistic.fit <- hima(simdat_bin$X, simdat_bin$Y, simdat_bin$M, 
family = "binomial", verbose = TRUE) 
head(hima.logistic.fit)

}
