\name{adjust_lmList}
\alias{adjust_lmList}
\alias{adjust_lmList,formula,data.frame-method}
\title{Fitting Common Models via \code{lm}}
\usage{
  adjust_lmList(formula, data, pool)
}
\arguments{
  \item{formula}{a linear formula such as that used by
  \code{lmList}, e.g. \code{y ~ x1 + ... + xn | g}, where
  \code{g} is a grouping factor.}

  \item{data}{a data frame containing the variables in the
  model.}

  \item{pool}{a logical value that indicates whether the
  pooled standard deviation/error should be used.}
}
\description{
  Separate linear models are fit via \code{lm} similar to
  \code{lmList}, however, \code{adjust_lmList} can handle
  models where a factor takes only one level within a
  group. In this case, the \code{formula} is updated
  eliminating the offending factors from the formula for
  that group as the effect is absorbed into the intercept.
}
\examples{
data(Exam, package = 'mlmRev')
sepLM <- adjust_lmList(normexam ~ standLRT + sex + schgend | school, data = Exam)
confint(sepLM)
}
\references{
  Douglas Bates, Martin Maechler and Ben Bolker (2012).
  lme4: Linear mixed-effects models using S4 classes. R
  package version 0.999999-0.
}
\seealso{
  \code{\link[lme4]{lmList}, \link[stats]{lm}}
}
\keyword{models}
\keyword{regression}

