% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suggest_mtries.R
\name{suggest_mtries}
\alias{suggest_mtries}
\title{Suggest Alternative mtries Values}
\usage{
suggest_mtries(p, family = c("classification", "regression"))
}
\arguments{
\item{p}{Integer. The number of features (predictors)
in the dataset. This value is used to compute
candidate mtries.}

\item{family}{Character. Must be either
"classification" or "regression". This
determines the set of candidate values.}
}
\value{
An integer vector of candidate values for
        \code{mtries}.
}
\description{
Provides a set of candidate values for the
  \code{mtries} parameter used in Random Forest models.
  The suggestions are computed based on the number of
  predictors (\code{p}) and the modeling family. For
  classification, the common default is \code{sqrt(p)},
  while for regression it is typically \code{p/3}. For
  family, alternative candidates are offered to aid model
  tuning.
}
\details{
For classification, the default is often
  \code{sqrt(p)}; alternative suggestions include
  \code{log2(p)} and \code{p^(1/3)}. For regression,
  the typical default is \code{p/3}, but candidates such as
  \code{p/2} or \code{p/5} may also be useful. The best
  choice depends on the data structure and predictor
  correlations.
}
\examples{
\dontrun{
  # For a classification task with 100 predictors:
  suggest_mtries(p = 100, family = "classification")

  # For a regression task with 100 predictors:
  suggest_mtries(p = 100, family = "regression")
}

}
\author{
E. F. Haghish
}
