% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Repeated.R
\name{hrm.test.matrix}
\alias{hrm.test.matrix}
\title{Test for main and interaction effects.}
\usage{
hrm.test.matrix(data, alpha = 0.05)
}
\arguments{
\item{data}{A list containing the data matrices of all groups. The rows are the independent subjects, these observations are assumed to be multivariate normally distributed. The columsn of all matrices need to be in the same order.}

\item{alpha}{alpha level used for the test}
}
\value{
Returns an object from class HRM containing
\item{result}{A dat frame with the results from the hypotheses tests.}
\item{alpha}{The type-I error rate which was used.}
\item{subject}{The column name identifying the subjects.}
\item{factors}{A list containing the whole- and subplot factors.}
}
\description{
Test for no main treatment effect, no main time effect, no simple treatment effect and no interaction between treatment and time
}
\examples{
# number patients per group
n = c(10,10)
# number of groups
a=2
# number of variables
d=40

# defining the list consisting of the samples from each group
mu_1 = mu_2 = rep(0,d)
# autoregressive covariance matrix
sigma_1 = diag(d)
for(k in 1:d) for(l in 1:d) sigma_1[k,l] = 1/(1-0.5^2)*0.5^(abs(k-l))
sigma_2 = 1.5*sigma_1
X = list(mvrnorm(n[1],mu_1, sigma_1), mvrnorm(n[2],mu_2, sigma_2))
X=lapply(X, as.matrix)
# test for the main treatment effect and print the p.value
hrm.test.matrix(data=X, alpha=0.05)
}
\keyword{export}
