% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seg.R
\name{seg}
\alias{seg}
\alias{print.seg}
\alias{plot.seg}
\title{Homogenous segmentation for road data.}
\usage{
seg(var = "Deflection", location = "SLK", interval = interval, unit = 10, data = data)
\method{print}{seg}(x, ...)
\method{plot}{seg}(x, range = 1:300, legend_location = "topright", ...)
}
\arguments{
\item{var}{A character of the name of a variable in a dataset,
such as a road pavement performance indicator.}

\item{location}{A character of the name of spatial locations in a dataset.}

\item{interval}{A vector of available segmentation intervals. The length of the vector is longer than 1.}

\item{unit}{A number of the unit of the interval data.}

\item{data}{A data frame of monitoring data.}

\item{x}{A list of homogenous segmentation result.}

\item{range}{A vector of a range of plot data.}

\item{legend_location}{A character of legend location.}

\item{...}{Ignore.}
}
\description{
Function for homogenous segmentation for road data using
             a moving coefficient of variation (CV) method.
}
\examples{
# preprocessing
def <- preprocessing(var = "Deflection", location = "SLK", data = deflection)
# smoothing
def$smooth_def <- segsmooth(var = "Deflection", range = 11, data = def)
# segmentation
interval <- seq(100, 500, 20)
seg1 <- seg(var = "smooth_def", location = "SLK", interval = interval, unit = 10, data = def)
seg1
plot(seg1, range = 1:994, legend_location = "topleft")

}
