% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segcompare.R
\name{segcompare}
\alias{segcompare}
\alias{print.segcompare}
\alias{plot.segcompare}
\title{Segments comparison of different homogeneous segmentations methods.}
\usage{
segcompare(start = "SLK.start", end = "SLK.end", var = "deflection",
                  data, segid.matrix, methods = NULL)
\method{print}{segcompare}(x, ...)
\method{plot}{segcompare}(x, ...)
}
\arguments{
\item{start}{A character of start location name of a spatial line.}

\item{end}{A character of end location name of a spatial line.}

\item{var}{A character or a character vector of variable names,
such as a road pavement performance indicator.}

\item{data}{A list of segmentation result.}

\item{segid.matrix}{A matrix of segmentations.}

\item{methods}{A vector of segmentation method names, default NULL.}

\item{x}{A list of segments comparison result.}

\item{...}{Ignore}
}
\description{
Segments comparison of different homogeneous segmentations methods.
}
\examples{
testdata <- tsdwa[1:300, ]
testdata$length <- testdata$SLK.end - testdata$SLK.start
variable <- c("Curvature", "Deflection", "BLI")
\donttest{
seg1 <- hs(start = "SLK.start", end = "SLK.end", var = variable,
           testdata, method = "shs", range = c(0.1, 0.5)) # 0.3 s
seg2 <- hs(start = "SLK.start", end = "SLK.end", var = variable,
           testdata, method = "cda", range = c(0.1, 0.5)) # 0.7 s
seg3 <- hs(start = "SLK.start", end = "SLK.end", var = variable,
           testdata, method = "mcv", range = c(0.1, 0.5)) # 0.6 s
segid.matrix <- cbind(seg1$seg.id, seg2$seg.id, seg3$seg.id)
}
data(segid.matrix)
cp <- segcompare(start = "SLK.start", end = "SLK.end", var = variable,
                 testdata, segid.matrix, methods = c("SHS", "CDA", "MCV")) # 4.8 s
cp
plot(cp)

}
