% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H2GM2D.R
\name{HTGM2Ddriver}
\alias{HTGM2Ddriver}
\title{HTGM2Ddriver}
\usage{
HTGM2Ddriver(
  dir,
  geneList,
  ontologies,
  GOGOA3,
  enrichThresh = 2,
  countThresh = 5,
  fdrThresh = 0.1,
  nrand = 100
)
}
\arguments{
\item{dir}{character string full path name to the directory acting as result repository}

\item{geneList}{character vector of user-supplied genes of interest}

\item{ontologies}{character vector of 2 ontologies e.g. c("biological_process","cellular_component")}

\item{GOGOA3}{return value of subsetGOGOA()}

\item{enrichThresh}{numerical acceptance threshold for enrichment passed to GoMiner}

\item{countThresh}{numerical acceptance threshold for gene count passed to GoMiner}

\item{fdrThresh}{numerical acceptance threshold for fdr passed to GoMiner}

\item{nrand}{integer number of randomizations passed to GoMiner}
}
\value{
returns no value, but saves hyperlinked SVG heatmap files to a results directory
}
\description{
driver to invoke GoMiner and HTGM2D, and compare the results
}
\examples{
\dontrun{
# this example takes too long to run, and
# GOGOA3.RData is too large to include in the R package
# so I need to load it from a file that is not in the package.
# Since this is in a file in my own file system, I could not
# include this as a regular example in the package.
# This example is given in full detail in the package vignette.
# You can generate GOGOA3.RData using the package 'minimalistGODB'
# or you can retrieve it from https://github.com/barryzee/GO
# load("~/GODB_RDATA/GOGOA3.RData")
geneList<-cluster52
ontologies<-c("biological_process","cellular_component")
dir<-tempdir()
HTGM2Ddriver(dir,geneList,ontologies,GOGOA3,enrichThresh=2,countThresh=5,fdrThresh=0.10,nrand=100)
}

}
