/*
 * Decompiled with CFR 0.152.
 */
package ptolemy.plot.plotml;

import com.microstar.xml.XmlException;
import ptolemy.plot.Histogram;
import ptolemy.plot.plotml.PlotMLParser;

public class HistogramMLParser
extends PlotMLParser {
    public HistogramMLParser(Histogram plot) {
        this._plot = plot;
    }

    public void endElement(String elementName) throws Exception {
        if (!elementName.equals("bars") && !elementName.equals("dataset")) {
            super.endElement(elementName);
        }
    }

    public void startElement(String elementName) throws XmlException {
        try {
            if (elementName.equals("barGraph")) {
                String widthSpec = (String)this._attributes.get("width");
                String offsetSpec = (String)this._attributes.get("offset");
                if (widthSpec != null && offsetSpec != null) {
                    double width = Double.valueOf(widthSpec);
                    double offset = Double.valueOf(offsetSpec);
                    ((Histogram)this._plot).setBars(width, offset);
                }
            } else if (elementName.equals("bin")) {
                if (this._plot instanceof Histogram) {
                    Histogram histogram = (Histogram)this._plot;
                    String widthSpec = (String)this._attributes.get("width");
                    String offsetSpec = (String)this._attributes.get("offset");
                    if (widthSpec != null && offsetSpec != null) {
                        double width = Double.valueOf(widthSpec);
                        histogram.setBinWidth(width);
                        double offset = Double.valueOf(offsetSpec);
                        histogram.setBinOffset(offset);
                    }
                }
            } else if (elementName.equals("dataset")) {
                ++this._currentDataset;
                this._currentPointCount = 0.0;
                String name = (String)this._attributes.get("name");
                if (name != null) {
                    this._plot.addLegend(this._currentDataset, name);
                }
            } else if (!elementName.equals("default")) {
                super.startElement(elementName);
            }
        }
        catch (Exception ex) {
            if (ex instanceof XmlException) {
                throw (XmlException)ex;
            }
            String msg = "XML element \"" + elementName + "\" triggers exception:\n  " + ex.toString();
            throw new XmlException(msg, this._currentExternalEntity(), this._parser.getLineNumber(), this._parser.getColumnNumber());
        }
        this._attributes.clear();
    }

    protected void _addPoint(boolean connected, String element) throws Exception {
        String ySpec = (String)this._attributes.get("y");
        this._checkForNull(ySpec, "No y value for element \"" + element + "\"");
        double y = Double.valueOf(ySpec);
        ((Histogram)this._plot).addPoint(this._currentDataset, y);
    }
}

