% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htrx_max.R
\name{htrx_max}
\alias{htrx_max}
\title{Maximum independent features for HTRX}
\usage{
htrx_max(nsnp, n_haps = NULL, cap = 40, max_int = NULL, htr = FALSE)
}
\arguments{
\item{nsnp}{a positive integer giving the number of single nucleotide polymorphisms (SNPs) included in the haplotypes.}

\item{n_haps}{a positive integer giving the number of haplotypes,
which is also the number of columns of the HTRX or HTR matrix.}

\item{cap}{a positive integer which manually sets the maximum number of independent features.
By default, \code{cap=40}.}

\item{max_int}{a positive integer which specifies the maximum number of SNPs that can interact.
If no value is given (by default), interactions between all the SNPs will be considered.}

\item{htr}{logical. If \code{htr=TRUE}, the functions returns the maximum number of independent
features for HTR. By default, \code{htr=FALSE}.}
}
\value{
\code{htrx_max} returns a positive integer giving the maximum
number of independent features to be included in the analysis.
}
\description{
The maximum number of independent features in principle from
haplotypes (i.e. interactions between SNPs) generated by Haplotype Trend Regression with eXtra flexibility (HTRX).
}
\details{
The maximum number of independent features in principle is \ifelse{html}{\out{2<sup>nsnp</sup>}}{\eqn{2^nsnp}}-1
for haplotypes containing interactions between all different numbers of SNPs.
However, if \code{max_int < nsnp}, i.e. only the interactions between at most \code{max_int} SNPs are investigated,
there will be fewer maximum number of independent features.
You can also manually set the upper limit of independent features (by setting \code{cap}) that can be included in the final HTRX or HTR model.
}
\examples{
## the maximum number of independent haplotypes consisted of 4 SNPs from HTRX
htrx_max(nsnp=4,n_haps=(3^4-1))
}
