% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotModelDiagnostics.R
\name{plotModelDiagnostics}
\alias{plotModelDiagnostics}
\title{Make the diagnostic plots for hierarchical voronoi tessellations}
\usage{
plotModelDiagnostics(model_obj)
}
\arguments{
\item{model_obj}{List. A list obtained from the trainHVT
function or scoreHVT function}
}
\value{
For trainHVT, Minimum Intra-DataPoint Distance Plot, Minimum Intra-Centroid Distance Plot
Mean Absolute Deviation Plot, Distribution of Number of Observations in Cells, for Training Data and
Mean Absolute Deviation Plot for Validation Data are plotted.
For scoreHVT Mean Absolute Deviation Plot for Training Data and Validation Data are plotted
}
\description{
This is the main function that generates diagnostic plots for 
hierarchical voronoi tessellations models and scoring.
}
\examples{
data("EuStockMarkets")
hvt.results <- trainHVT(EuStockMarkets, n_cells = 60, depth = 1, quant.err = 0.1, 
                       distance_metric = "L1_Norm", error_metric = "max",
                       normalize = TRUE,quant_method="kmeans",diagnose = TRUE, 
                       hvt_validation = TRUE)
plotModelDiagnostics(hvt.results)
}
\seealso{
\code{\link{plotHVT}}
}
\author{
Shubhra Prakash <shubhra.prakash@mu-sigma.com>
}
\keyword{Diagnostics_or_Validation}
