% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/function_SubidAttributeSummary.R
\name{SubidAttributeSummary}
\alias{SubidAttributeSummary}
\title{Summarize subbasin attributes}
\usage{
SubidAttributeSummary(
  subids = NULL,
  gd,
  bd = NULL,
  gc = NULL,
  desc = NULL,
  group = NULL,
  group.upstream = TRUE,
  signif.digits = NULL,
  progbar = FALSE,
  summarize.landuse = TRUE,
  summarize.soil = TRUE,
  summarize.crop = TRUE,
  summarize.upstreamarea = TRUE,
  unweighted.gd.cols = NULL,
  upstream.gd.cols = NULL,
  olake.slc = NULL,
  bd.weight = FALSE,
  mapoutputs = NULL
)
}
\arguments{
\item{subids}{Vector containing SUBIDs of subbasins to summarize.}

\item{gd}{Imported HYPE GeoData.txt file. See \code{\link{ReadGeoData}}.}

\item{bd}{Imported HYPE BranchData.txt file. See \code{\link{ReadBranchData}}.}

\item{gc}{Imported HYPE GeoClass.txt file. See \code{\link{ReadGeoClass}}.}

\item{desc}{Optional, Imported HYPE Description file. If provided, then dataframe columns will be renamed using the short names in the description file. See \code{\link{ReadDescription}}.}

\item{group}{Optional, Integer vector of same length as number of SLC classes in gd. Alternative grouping index specification to gcl + type for \code{\link{UpstreamGroupSLCClasses}}.}

\item{group.upstream}{Logical, if \code{TRUE}, then SLC fractions will be summarized for upstream areas using \code{\link{UpstreamGroupSLCClasses}}.
If \code{FALSE}, then SLC fractions will be summarized for subbasin area only using \code{\link{GroupSLCClasses}}.}

\item{signif.digits}{Optional, Integer specifying number of significant digits to round outputs to. Used by \code{\link{UpstreamGroupSLCClasses}} and \code{link{UpstreamGeoData}}.}

\item{progbar}{Logical, display a progress bar while calculating summary information. Used by \code{\link{UpstreamGroupSLCClasses}} and \code{link{UpstreamGeoData}}.}

\item{summarize.landuse}{Logical, specify whether or not subbasin upstream landuse fractions should be calculated.}

\item{summarize.soil}{Logical, specify whether or not subbasin upstream soil fractions should be calculated.}

\item{summarize.crop}{Logical, specify whether or not subbasin upstream crop fractions should be calculated.}

\item{summarize.upstreamarea}{Logical, specify whether or not subbasin upstream area should be calculated.}

\item{unweighted.gd.cols}{Vector, names of \code{gd} columns which should be joined to the output data frame without any additional processing.}

\item{upstream.gd.cols}{Vector, specify column names of \code{gd} which should be summarized using \code{\link{UpstreamGeoData}}.}

\item{olake.slc}{Integer, SLC class number representing outlet lake fractions. Used by \code{\link{UpstreamGeoData}}.}

\item{bd.weight}{Logical, if set to TRUE, flow weights will be applied for areas upstream of stream bifurcations. See \code{\link{UpstreamGeoData}}.}

\item{mapoutputs}{Vector, paths to mapoutput files that should be read by \code{\link{ReadMapOutput}} and joined to the output data frame.}
}
\value{
\code{SubidAttributeSummary} returns a data frame object containing subbasin attribute summary information.
}
\description{
Prepare data frame containing summary of subbasin attributes.
}
\details{
\code{SubidAttributeSummary} can be used to create a data frame object containing subbasin attribute summary information. This data frame can then be used as the \code{attributes}
input for \code{\link{PlotPerformanceByAttribute}}. The function can summarize subbasin upstream landuse, soil, and crop fractions using \code{\link{UpstreamGroupSLCClasses}}. In addition, the
function can summarize upstream GeoData information using \code{\link{UpstreamGeoData}}. Finally, the function can join mapoutput and GeoData columns directly to the output data frame (i.e without further processing).
}
\examples{
\donttest{
subass <- ReadSubass(filename = system.file("demo_model", "results",
  "subass1.txt",
  package = "HYPEtools"
), check.names = TRUE)
gd <- ReadGeoData(filename = system.file("demo_model",
  "GeoData.txt",
  package = "HYPEtools"
))
gc <- ReadGeoClass(filename = system.file("demo_model",
  "GeoClass.txt",
  package = "HYPEtools"
))

SubidAttributeSummary(subids <- subass$SUBID,
  gd = gd, gc = gc,
  mapoutputs = c(system.file("demo_model", "results", "mapCOUT.txt", package = "HYPEtools")),
  upstream.gd.cols = c("SLOPE_MEAN")
)
}

}
\seealso{
\code{\link{UpstreamGroupSLCClasses}}, \code{\link{GroupSLCClasses}}, \code{\link{UpstreamGeoData}}, \code{\link{ReadMapOutput}} for subbasin attribute summary functions; \code{\link{PlotPerformanceByAttribute}} for related plotting function.
}
