% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genDataLoad.R
\name{genDataLoad}
\alias{genDataLoad}
\title{Loading the data previously read in and saved by "genDataRead"}
\usage{
genDataLoad(filename = stop("'filename' must be given!"), dir.in = ".")
}
\arguments{
\item{filename}{The base of the filenames; i.e. if the data is saved in
"my_data_gen.ffData", "my_data_gen.RData" and "my_data_cov.RData", then the 'filename'
should be "my_data".}

\item{dir.in}{The path to the directory where files were saved (defaults to the
current directory).}
}
\value{
A list object with three elements:
  \itemize{
    \item \emph{cov.data} - a \code{data.frame} with covariate data (if available in
       the input file)
    \item \emph{gen.data} - a list with chunks of the genetic data; the data is divided
       column-wise, using 10,000 columns per chunk; each element of this list is a
       \link[ff]{ff} matrix
    \item \emph{aux} - a list with meta-data and important parameters.
  }
}
\description{
This function loads the data from the saved .ffData and .RData files,
and prepares the data to subsequent analysis.
}
