#' Model Gene Compendium Data Set
#'
#' A data frame which contains information from 1345 unique wheat lines on the Sst1 solid stem locus.
#'
#' @format A data frame with 1345 rows and 7 columns:
#'
#'  \describe{
#'
#'    \item{Trait}{A short discription of the phenotype associated with the gene}
#'    \item{Chromosome}{The chromosome where the gene resides}
#'    \item{Gene}{The name of the gene}
#'    \item{Nursery}{The program which produced the gene call for the genotype}
#'    \item{Line}{A breeder assigned line designation}
#'    \item{FullSampleName}{A designation unique to the line found in the genotypic matrix}
#'    \item{Call}{A 'call' given for the allelic state. For this package, it is best to format the non desiarable allele as "non_gene" and the heterozygous state as "het_gene".}
#'
#'  }
#'
#' @source {Generated by Zachary James Winn for the CSU breeding program via USDA-ARS gene reports and in-house gene assays}
#'
#' @examples
#' data("gene_comp") #lazy loads the dataset for use in the package
"gene_comp"
