% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newcompassRose.R
\name{newcompassRose}
\alias{newcompassRose}
\title{Display a compass rose}
\usage{
newcompassRose(x, y, rot = 0, cex = 1, col = "black",
  col.arrows.light = "white", col.arrows.dark = "black")
}
\arguments{
\item{x}{The position of the center of the compass rose in user units.}

\item{y}{The position of the center of the compass rose in user units.}

\item{rot}{Rotation for the compass rose in degrees. See Details.}

\item{cex}{The character expansion to use in the display.}

\item{col}{The color of text}

\item{col.arrows.light}{The color of lighter lines}

\item{col.arrows.dark}{The color of darker lines}
}
\value{
none
}
\description{
Displays a basic compass rose, usually to orient a map.\cr
newcompassRose displays a conventional compass rose at the position requested.\cr 
The size of the compass rose is determined by the character expansion, 
as the central "rose" is calculated relative to the character size.\cr
Rotation is in degrees counterclockwise.
}
\details{
newcompassRose Display a compass rose
}
\examples{
\dontrun{
library(HelpersMG)
require("maps")
map("world", "China")
newcompassRose(x=110, y=35, col.arrows.light="grey")
}
}
\author{
modified from Jim Lemon; See compassRose {sp}
}

