% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HextractoR.R
\name{HextractoR}
\alias{HextractoR}
\title{HextractoR: Integrated Tool for Hairping Extraction of RNA Sequences}
\usage{
HextractoR(input_file, min_valid_nucleotides = 500, window_size = 160,
  window_step = 30, only_sloop = T, min_length = 60, min_bp = 16,
  trim_sequences = F, margin_bp = 6, blast_evalue = 1,
  identity_threshold = 90, nthreads = 1, nworks = 1, filter_files = { })
}
\arguments{
\item{input_file}{filename of the fasta file to proccess}

\item{min_valid_nucleotides}{Each input sequence must have this quantity of
valid nucleotides (not 'N') to be processed.}

\item{window_size}{Number of bases in the windows.}

\item{window_step}{Window step. This number defines indirectly the overlap:
window_overlap=window_size-window_step}

\item{only_sloop}{Only extract single loop sequence.}

\item{min_length}{Minimum sequence length. Shorter sequences are discarded.}

\item{min_bp}{Minimum number of base-pairs that must form a sequence.}

\item{trim_sequences}{Use some heuristics to trim the hairpins.}

\item{margin_bp}{When the sequence is trimmed, at least min_bp+margin_bp
base-pairs are left.}

\item{blast_evalue}{e-value used in blast to match the extracted sequences
with the sequences from the filter files.}

\item{identity_threshold}{Identity threshold used to match sequences with the
sequences from the filter files.}

\item{nthreads}{Allows using more than one thread in the execution.}

\item{nworks}{Split each sequence in nworks to use less RAM memory.}

\item{filter_files}{Fasta files with known sequences to separate the output
stems.}
}
\value{
A list with the path of the output files and the result of the
proccessing of each sequence (if it was succesful or failed)
}
\description{
To preprocess a genome, you need a file containing the raw genome in fasta
format. To run HExtractor, simply call the main function. This function
creates 2 files in the "out" folder and automatically names them.
}
\examples{
# Small example without filter files
library(HextractoR)
# First we get the path of the example FASTA file
fpath <- system.file("Example_tiny.fasta", package="HextractoR")
# To run HextractoR, simply call the main function
HextractoR(input_file = fpath)
\donttest{# Other example with filter files and bigger input file
fpath1 <- system.file("Example_human.fasta", package="HextractoR")
fpath2 <- system.file("Example_pre-miRNA.fasta", package="HextractoR")
HextractoR(input_file = fpath1, filter_files = {fpath2})
# This function creates 2 files in the working directory and automatically
# names them.}

}
