% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/Met_distributionH.R
\docType{methods}
\name{crwtransform}
\alias{crwtransform}
\alias{crwtransform,distributionH-method}
\title{Method \code{crwtransform}}
\usage{
crwtransform(object)

\S4method{crwtransform}{distributionH}(object)
}
\arguments{
\item{object}{a \code{distributionH} object}
}
\value{
A list containing \item{$Centers }{The midpoints of the bins of the
histogram} \item{$Radii }{The half-lenghts of the bins of the histogram}
\item{$Weights }{The relative frequencies or the probailities associated with
each bin (the sum is equal to 1)}
}
\description{
Method \code{crwtransform}

Centers and ranges calculation for bins of a histogram. It is useful for a
very fast computation of statistics and methods based on the L2 Wassertein
distance between histograms.
}
\examples{
##---- A mydist distribution ----
mydist<-distributionH(x=c(1,2,3,10), p=c(0,0.1,0.5,1))
##---- Compute the cfd value for q=5 (not observed) ----
crwtransform(mydist)
}
\author{
Antonio Irpino
}
\references{
Irpino, A., Verde, R., Lechevallier, Y. (2006) \emph{Dynamic
clustering of histograms using Wasserstein metric}, In: Proceedings of
COMPSTAT 2006, Physica-Verlag, 869-876
}
\keyword{distribution}

