% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fuzzy_cmeans.R
\name{WH_fcmeans}
\alias{WH_fcmeans}
\title{Fuzzy c-means of a dataset of histogram-valued data}
\usage{
WH_fcmeans(x, k, m = 1.6, rep, simplify = FALSE, qua = 10,
  standardize = FALSE)
}
\arguments{
\item{x}{A MatH object (a matrix of distributionH).}

\item{k}{An integer, the number of groups.}

\item{m}{A number grater than 0, a fuzziness coefficient (default \code{m}=1.6).}

\item{rep}{An integer, maximum number of repetitions of the algorithm (default \code{rep}=5).}

\item{simplify}{A logic value (default is FALSE), if TRUE histograms are recomputed in order to speed-up the algorithm.}

\item{qua}{An integer, if \code{simplify}=TRUE is the number of quantiles used for recodify the histograms.}

\item{standardize}{A logic value (default is FALSE). If TRUE, histogram-valued data are standardized,  variable by variable, using the Wassertein based standard deviation. Use if one wants to have variables with std equal to one.}
}
\value{
a list with the results of the fuzzy c-means of the set of Histogram-valued data \code{x} into  \code{k} cluster.
}
\description{
The function implements the fuzzy c-means for a set of histogram-valued data.
}
\section{Slots}{

\describe{
\item{\code{solution}}{A list.Returns the best solution among the \code{rep}etitions, i.e. 
the one having the minimum sum of squares deviation.}

\item{\code{solution$membership}}{A matrix. The membership degree of each unit to each cluster.}

\item{\code{solution$IDX}}{A vector. The crisp assignement to a cluster.}

\item{\code{solution$cardinality}}{A vector. The cardinality of each final cluster (after the crisp assignement).}

\item{\code{solution$Crit}}{A number. The criterion (Sum of square deviation 
from the prototypes) value at the end of the run.}

\item{\code{quality}}{A number. The percentage of Sum of square deviation explained by the model. 
(The higher the better)}
}}
\examples{
results=WH_fcmeans(x = BLOOD,k = 2,m = 1.5,rep = 10,simplify = TRUE,qua = 10,standardize = TRUE)
}

