% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Met_HTS.R
\docType{methods}
\name{plot-HTS}
\alias{plot-HTS}
\alias{plot,HTS-method}
\title{Method plot for a histogram time series}
\usage{
\S4method{plot}{HTS}(x, y = "missing", type = "VIOLIN", border = "black", maxno.perplot = 30)
}
\arguments{
\item{x}{a \code{distributionH} object}

\item{y}{not used in this implementation}

\item{type}{(optional) a string describing the type of plot, default="BOXPLOT".\cr
Other allowed types are \cr
"VIOLIN"=a violin-plot representation,}

\item{border}{(optional) a string the color of the border of the plot, default="black".}

\item{maxno.perplot}{An integer (DEFAULT=30). Maximum number of timestamps per row.
It allows a plot organized by rows, each row of the plot contains a max number of time stamps
 indicated by maxno.perplot.}
}
\description{
An overloading plot function for a \code{HTS} object. The method returns a graphical representation
of a histogram time series.
}
\examples{
plot(subsetHTS(RetHTS, from = 1, to = 10)) # plots RetHTS dataset
\dontrun{
plot(RetHTS, type = "BOXPLOT", border = "blue", maxno.perplot = 20)
plot(RetHTS, type = "VIOLIN", border = "blue", maxno.perplot = 20)
plot(RetHTS, type = "VIOLIN", border = "blue", maxno.perplot = 10)
}
}
