% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeJagsFormula.R
\name{writeJagsFormula}
\alias{writeJagsFormula}
\alias{writeJagsFormula.cpt}
\alias{writeJagsFormula.glm}
\alias{writeJagsFormula.lm}
\alias{writeJagsFormula.multinom}
\alias{writeJagsFormula.survreg}
\alias{writeJagsFormula.xtabs}
\title{Write the JAGS Formula for a Hyde Node}
\usage{
writeJagsFormula(fit, nodes, ...)

\method{writeJagsFormula}{cpt}(fit, nodes, ...)

\method{writeJagsFormula}{glm}(fit, nodes, ...)

\method{writeJagsFormula}{lm}(fit, nodes, ...)

\method{writeJagsFormula}{multinom}(fit, nodes, ...)

\method{writeJagsFormula}{survreg}(fit, ...)

\method{writeJagsFormula}{xtabs}(fit, ...)
}
\arguments{
\item{fit}{a model object}

\item{nodes}{a vector of node names, usually passed from \code{network$nodes}}

\item{...}{Additional arguments to be passed to other methods}
}
\description{
Based on the information provided about the node,
  an appropriate JAGS model is written in text.  This is combined with 
  the other node models to generate the complete network.
}
\details{
Methods for different model objects can be written so that 
  this function can be extended as desired.
  
  The resulting formulas are based on the coefficient matrix of the fitted
  model, and the returned result is the JAGS code representing the 
  regression equation of the model.
  
  In the \code{writeJagsFormula.glm} method, appropriate transformations
  exist for the following combinations:
  \enumerate{
    \item family = binomial; link = logit
    \item family = poisson; link = log
    \item family = gaussian; link = identity (calls \code{writeJagsFormula.lm})
  }
}
\examples{
data(PE, package="HydeNet")
fit <- lm(d.dimer ~ pregnant + pe, data=PE)
writeJagsFormula(fit, nodes=c("d.dimer", "pregnant", "pe"))

fit.glm <- glm(death ~ pe + treat, data=PE, family="binomial")
writeJagsFormula(fit.glm, nodes=c("death", "pe", "treat"))
}
\author{
Jarrod Dalton and Benjamin Nutter
}
\seealso{
\code{\link{writeJagsModel}}, \code{\link{writeNetworkModel}}
}

