% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rToJags.R
\name{TranslateFormula}
\alias{TranslateFormula}
\alias{rToJags}
\title{Translate R Formula to JAGS}
\usage{
rToJags(f)
}
\arguments{
\item{f}{R formula object}
}
\description{
While most functions available in JAGS have equivalents in R,
  they don't always use the exact same names.  R formulas are converted
  to character strings, function names translated, and the corresponding
  JAGS formula is returned.
}
\details{
Only a limited subset of R functions are recognized here, but no 
  attempt is made to restrict the user to functions that will be recognized
  by JAGS.  For now, the user should remain aware of what functions
  are available in JAGS and only use the corresponding functions in R.
  The JAGS functions may be referenced in the JAGS user manual (see 
  References).  The corresponding R functions are listed in the 
  \code{jagsFunctions} data set (use \code{data(jagsFunctions)} to 
  review).
}
\references{
\url{http://people.stat.sc.edu/hansont/stat740/jags_user_manual.pdf}
}
\author{
Jarrod Dalton and Benjamin Nutter
}
