% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Hydro3Stats.R
\name{Hydro3_Plot}
\alias{Hydro3_Plot}
\title{Hydro3 plot}
\usage{
Hydro3_Plot(
  H3,
  useU = FALSE,
  lwd = 2,
  cex.lab = 2,
  cex.axis = 1.3,
  pch = 19,
  col = "red"
)
}
\arguments{
\item{H3}{list, resulting from a call to Hydro3_Estimation()}

\item{useU}{logical, use reduced variate u rather than return period T in plots?}

\item{lwd, cex.lab, cex.axis, pch}{numeric, graphical parameters, see ?graphics::par}

\item{col}{character, graphical parameter (points color)}
}
\value{
nothing (just creates a plot)
}
\description{
Plot summarizing the results of Hydro3_Estimation()
}
\examples{
y=stats::rnorm(50)
H3=Hydro3_Estimation(y,'Normal')
Hydro3_Plot(H3)
}
