% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{TranscriptRanges}
\alias{TranscriptRanges}
\alias{trans.ranges.GRCh37}
\alias{trans.ranges.GRCh38}
\alias{trans.ranges.GRCm38}
\title{Transcript ranges data}
\format{
A \code{\link[data.table]{data.table}} which contains transcript
  range and strand information for a particular reference genome.
  \code{colname}s are \code{chrom}, \code{start}, \code{end}, \code{strand},
  \code{Ensembl.gene.ID}, \code{gene.symbol}. It uses one-based coordinates.

An object of class \code{data.table} (inherits from \code{data.frame}) with 19083 rows and 6 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 19096 rows and 6 columns.

An object of class \code{data.table} (inherits from \code{data.frame}) with 20325 rows and 6 columns.
}
\source{
\url{ftp://ftp.ebi.ac.uk/pub/databases/gencode/Gencode_human/release_30/GRCh37_mapping/gencode.v30lift37.annotation.gff3.gz}

\url{ftp://ftp.ebi.ac.uk/pub/databases/gencode/Gencode_human/release_30/gencode.v30.annotation.gff3.gz}

\url{ftp://ftp.ebi.ac.uk/pub/databases/gencode/Gencode_mouse/release_M21/gencode.vM21.annotation.gff3.gz}
}
\usage{
trans.ranges.GRCh37

trans.ranges.GRCh38

trans.ranges.GRCm38
}
\description{
Transcript ranges and strand information for a particular reference genome.
}
\details{
This information is needed to generate catalogs that
depend on transcriptional
strand information, for example catalogs of 
class \code{SBS192Catalog}. 

\code{trans.ranges.GRCh37}:  \strong{Human} GRCh37. 

\code{trans.ranges.GRCh38}:  \strong{Human} GRCh38. 

\code{trans.ranges.GRCm38}:  \strong{Mouse} GRCm38. 

For these two tables, only genes that are associated with a CCDS ID are kept for transcriptional
strand bias analysis. 

This information is needed for \code{\link{StrelkaSBSVCFFilesToCatalog}}, \cr
\code{\link{StrelkaSBSVCFFilesToCatalogAndPlotToPdf}}, 
\code{\link{MutectVCFFilesToCatalog}}, \cr
\code{\link{MutectVCFFilesToCatalogAndPlotToPdf}},
\code{\link{VCFsToSBSCatalogs}} and \code{\link{VCFsToDBSCatalogs}}.
}
\examples{
trans.ranges.GRCh37
# chrom    start      end strand Ensembl.gene.ID  gene.symbol
#     1    65419    71585      + ENSG00000186092        OR4F5
#     1   367640   368634      + ENSG00000235249       OR4F29
#     1   621059   622053      - ENSG00000284662       OR4F16
#     1   859308   879961      + ENSG00000187634       SAMD11
#     1   879583   894689      - ENSG00000188976        NOC2L
#   ...      ...      ...    ...             ...          ... 
}
\keyword{datasets}
