% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/icd_history.R
\name{icd_history}
\alias{icd_history}
\title{Historize a list of ICD codes to cover the specified years}
\usage{
icd_history(icd_expand, years, custom_transitions = NULL)
}
\arguments{
\item{icd_expand}{A data.frame (e.g. as generated by the function icd_expand)}

\item{years}{Years to historize (e.g. 2005:2014)}

\item{custom_transitions}{(Optional) A data.frame containing custom transitions to complement the official transitions provided by \code{icd_meta_transition}.}
}
\value{
data.frame with columns YEAR, ICD_CODE, ICD_COMPRESSED, ICD_LABEL and, if specified, DIAG_GROUP
}
\description{
The function \code{icd_history} takes the result of \code{icd_expand},
specified for a particular year, and returns a data.frame
containing all corresponding codes for the specified years
(from 2003). To do this, it applies the ICD-10-GM transition
tables to map codes between successive ICD-10-GM versions.
Only automatic transitions are followed.
}
\examples{
# Between 2018 and 2019, causalgia (G56.4) was reclassified
# under G90 as a complex regional pain syndrome
icd_meta <- data.frame(ICD = "G56.4", ICD_LABEL = "Causalgia")
icd_meta_expanded <- icd_expand(icd_meta, year = 2018, col_meta = "ICD_LABEL")
icd_history(icd_meta_expanded, years = 2018:2019)
}
