% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CalcVarTheta.R
\name{CalcVarParam}
\alias{CalcVarParam}
\alias{CalcVarParamRSInts}
\alias{CalcVarThetaWeib}
\alias{CalcVarThetaWeibRS}
\alias{CalcVarNpmle}
\alias{CalcVarNpmleRS}
\title{Variance estimation for the main proportional hazards model}
\usage{
CalcVarParam(theta, tm, event, Z, Q, ps, ps.deriv, w, w.res, fit.cox)

CalcVarParamRSInts(theta, tm, event, Z, Q, ps, ps.deriv, w, w.res,
  fit.cox.rs.ints, pts.for.ints, n.etas.per.fit)

CalcVarThetaWeib(beta, etas, tm, event, ps, ps.deriv.shape, ps.deriv.scale, w,
  w.res)

CalcVarThetaWeibRS(beta, etas.matrix, tm, event, ps.rs, ps.deriv.shape.rs,
  ps.deriv.scale.rs, w, w.res)

CalcVarNpmle(tm, event, w, w.res, BS = 100, CI = T)

CalcVarNpmleRS(tm, event, w, w.res, BS = 100, CI = T)
}
\arguments{
\item{theta}{Coefficient vector from main PH model. First coefficient corresponds to X, the rest to Z}

\item{tm}{Vector of observed main event time or censoring time}

\item{event}{Vector of censoring indicators. \code{1} for event \code{0} for censored}

\item{Z}{Additional variables for the main model other than the binary covariate}

\item{Q}{For PH calibration models: additional covariates}

\item{ps}{A matrix. Rows are observations, columns are time pointas of the events. The entry at the i-th row and j-column is
the conditional probability of positive exposure status for observation i at the j-th event time.}

\item{ps.deriv}{A matrix. Rows are observations, columns are time points of the events.  The derivative of \code{ps} with 
respect to the calibration model parameters}

\item{w}{A matrix of time points when measurements on the binary covariate were obtained.}

\item{w.res}{A matrix of measurement results of the binary covariate. The measurement corresponding to the time points in \code{w}.}

\item{fit.cox}{For PH calibration models:  The result of \code{icenReg::ic_sp} on the interval-censored data}

\item{fit.cox.rs.ints}{For grouped risk-set PH calibraion: The result of \code{FitCalibCoxRSInts} on the interval-censored data}

\item{pts.for.ints}{For grouped-risk set PH calibraion: Points defining the intervals for grouping risk-sets (first one has to be zero). Should be sorted from zero up}

\item{n.etas.per.fit}{For grouped-risk set PH calibraion: A vector. Total number of parameters for each PH calibration fit.}

\item{beta}{Coefficient of the binary covariate. The analogue of theta for non-PH calibration models}

\item{etas}{For Weibull calibration: Shape and scale parameters of the Weibull calibration model.}

\item{ps.deriv.shape}{The derivative of \code{ps} with respect to the shape parameter of the Weibull calibration model.}

\item{ps.deriv.scale}{The derivative of \code{ps} with respect to the scale parameter of the Weibull calibration model.}

\item{etas.matrix}{For Weibull risk-set calibration: Two-columns matrix. Each row contains shape and scale parameters from a Weibull risk-set calibration model}

\item{ps.rs}{A matrix. Rows are observations, columns are time points of the events. The entry at the i-th row and j-column is
the conditional probability of positive exposure status for observation i at the j-th event time.}

\item{ps.deriv.shape.rs}{For Weibull risk-set calibration:The derivative of \code{ps} with respect to the shape parameters of the Weibull risk-set calibration models.}

\item{ps.deriv.scale.rs}{For Weibull risk-set calibration:The derivative of \code{ps} with respect to the scale parameters of the Weibull risk-set calibration models.}

\item{BS}{For nonparametric calibration: Number of bootstrap iterations, Default: 100}

\item{CI}{For nonparametric calibration: Should the function return confidence intervals?, Default: T}
}
\value{
The covariance matrix. The first row and column are for the binary exposure.

For nonparametric calibration: Variance estimate and possibly confidence interval for the log hazard-ratio of the binary exposure under 
a nonparametric calibration model.
}
\description{
Estimation of the covariance matrix for the parameters of the main proportional hazards model. 
This includes the variance of the binary exposure estimate and the other covariates, if included in the model. 
Each function correspond to a different calibration (or risk-set calibration model).

For nonparametric calibration, bootstrap calculations of the variance and confidence interval for the for the log hazard-ratio of the binary exposure.
}
\examples{
# Simulate data set
sim.data <- ICcalib:::SimCoxIntervalCensSingle(n.sample = 200, lambda = 0.1, alpha = 0.25, 
                                               beta0 = log(0.5), mu = 0.2, n.points = 2, 
                                               weib.shape = 1, weib.scale = 2)
case.times <- sim.data$obs.tm[sim.data$delta==1]
# Fit a Weibull calibration model for the covariate starting time distribution
calib.weib.params <- FitCalibWeibull(w = sim.data$w, w.res = sim.data$w.res)
px <- t(sapply(case.times, CalcWeibullCalibP, w = sim.data$w, 
               w.res =  sim.data$w.res, weib.params = calib.weib.params))
# Calculate derivative matrices
px.deriv.shape <- t(sapply(case.times, ICcalib:::CalcWeibullCalibPderivShape, 
w = sim.data$w, w.res =  sim.data$w.res, weib.params = calib.weib.params))
px.deriv.scale <- t(sapply(case.times, ICcalib:::CalcWeibullCalibPderivScale, 
w = sim.data$w, w.res = sim.data$ w.res, weib.params = calib.weib.params))
# Point estimate 
est.weib.calib <- optimize(f = ICcalib:::CoxLogLikX,  tm = sim.data$obs.tm, 
                           event = sim.data$delta, ps = px, interval = c(-50,50), 
                           maximum = TRUE)$maximum
# Variance estimate (no addtional covariates)
var.beta.wb <- CalcVarThetaWeib(beta = est.weib.calib, etas = calib.weib.params, 
                                tm = sim.data$obs.tm, event = sim.data$delta, 
                                ps = px, ps.deriv.shape = px.deriv.shape, 
                                ps.deriv.scale =  px.deriv.scale, w = sim.data$w, 
                                w.res = sim.data$w.res)
 print(est.weib.calib)
 print(var.beta.wb)                               
}
