% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.ICcforest.R
\name{predict.ICcforest}
\alias{predict.ICcforest}
\title{Predict from an ICcforest model}
\usage{
\method{predict}{ICcforest}(object, newdata = NULL, OOB = FALSE,
  suppress = TRUE, type = c("response", "prob", "weights", "node"),
  FUN = NULL, simplify = TRUE, scale = TRUE, ...)
}
\arguments{
\item{object}{an object as returned by \code{\link{ICcforest}}.}

\item{newdata}{an optional data frame containing test data.}

\item{OOB}{a logical specifying whether out-of-bag predictions are desired


(only if \code{newdata = NULL}).}

\item{suppress}{a logical specifying whether the messages from \code{\link[icenReg]{getFitEsts}} 
are suppressed. If \code{FALSE}, the messages are printed. \code{suppress = TRUE} is set by default.}

\item{type}{a character string denoting the type of predicted value returned. 


For \code{"type = response"}, the mean of a numeric response, the median survival time for 
the interval-censored response is returned. For \code{"type = prob"}, a list with the survival 
function constructed using the non-parametric maximum likelihood estimator for each observation 
is returned. \code{"type = weights"} returns an integer vector of prediction weights. 
For \code{type = "node"}, a list of terminal node ids for each of the trees in the 
forest is returned.}

\item{FUN}{a function to compute summary statistics. Predictions for each node must be 
computed based on arguments \code{(y, w)} where \code{y} is the response and \code{w} are case 
weights.}

\item{simplify}{a logical indicating whether the resulting list of predictions should be 
converted to a suitable vector or matrix (if possible), see \code{\link[partykit]{cforest}}.}

\item{scale}{a logical indicating scaling of the nearest neighbor weights by the sum of weights 
in the corresponding terminal node of each tree, see \code{\link[partykit]{cforest}}.}

\item{...}{additional arguments.}
}
\value{
An object of class \code{ICcforest}, as a subclass of \code{\link[partykit]{cforest}}.
}
\description{
Compute predictions from ICcforest objects.
}
\examples{
library(icenReg)
data(miceData)

## For ICcforest to run, Inf should be set to be a large number, for example, 9999999.
miceData$u[miceData$u == Inf] <- 9999999.

## First, fit an iterval-censored conditional inference forest
Cforest <- ICcforest(formula = Surv(l,u,type="interval2")~grp, data = miceData)
## Predict the survival function constructed using the non-parametric maximum likelihood estimator
Pred <- predict(Cforest, type = "prob")

## Out-of-bag prediction of the median survival time
PredOOB <- predict(Cforest, type = "response", OOB = TRUE)

}
\seealso{
\code{\link{sbrier_IC}} for evaluation of model fit for interval-censored data
}
