% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qsoverlay.R
\name{qsoverlay}
\alias{qsoverlay}
\title{PSD with an overlay variable.}
\usage{
qsoverlay(x, xoverlay, location)
}
\arguments{
\item{x}{A numeric vector of a explanatory variable}

\item{xoverlay}{A character variable of an explanatory variable}

\item{location}{A matrix of spatial locations}
}
\value{
A PSD value of an overlay variable.
}
\description{
PSD with an overlay variable.
}
\examples{
library(GD)
data <- sim[, 4:6]
data.disc <- apply(data, 2, FUN = function(x) disc(x, 4, "quantile"))
layers <- do.call(cbind, lapply(1:ncol(data), function(x)
  data.frame(cut(data[, x], data.disc[[x]]$itv, include.lowest = TRUE))))
names(layers) <- names(data)
fo <- fuzzyoverlay(y = sim[,1], layers = layers, method = "fuzzyAND")
qo <- qsoverlay(x = data, xoverlay = fo$fuzzylayer,
                location = sim[, c("lo","la")])

}
