% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatialfuncs.r
\name{get.theta.permute}
\alias{get.theta.permute}
\title{get the null distribution of the \code{get.theta} function}
\usage{
get.theta.permute(posmat, fun, r = 1, r.low = rep(0, length(r)),
  permutations)
}
\arguments{
\item{posmat}{a matrix with columns type, x and y}

\item{fun}{the function to evaluate}

\item{r}{the series of spatial distances we are interested in}

\item{r.low}{the low end of each range....0  by default}

\item{permutations}{the number of permute iterations}
}
\value{
theta values for all the distances we looked at
}
\description{
Does permutations to calculate the null distribution of get theta
if there were no spatial dependence. Randomly reassigns coordinates
to each observation permutations times
}
\examples{
\dontrun{
 R/examples/get_theta_permute.R
 }

}
\seealso{
Other get.theta: \code{\link{get.theta.bootstrap}},
  \code{\link{get.theta.ci}},
  \code{\link{get.theta.typed.bootstrap}},
  \code{\link{get.theta.typed.permute}},
  \code{\link{get.theta.typed}}, \code{\link{get.theta}}
}

