% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGraph.R
\name{plotGraph}
\alias{plotGraph}
\title{Plot and Stats Computation for IFC Graph}
\usage{
plotGraph(
  obj,
  graph,
  draw = FALSE,
  stats_print = draw,
  color_mode = c("white", "black")[1],
  add_key = "panel",
  precision = c("light", "full")[1],
  trunc_labels = 38,
  trans = asinh,
  bin,
  viewport = "ideas",
  ...
)
}
\arguments{
\item{obj}{an `IFC_data` object extracted with features extracted.}

\item{graph}{a graph from 'obj' or a list that can be coerced by \code{\link{buildGraph}}.}

\item{draw}{whether to draw plot or not. Default is FALSE.}

\item{stats_print}{whether to print stats or not. Default is given by 'draw' argument.}

\item{color_mode}{whether to extract colors from 'obj' in white or black mode. Default is "white".}

\item{add_key}{whether to draw a "global" key under title or in the first "panel" or "both". Default is "panel".\cr
Accepted values are either: FALSE, "panel", "global", "both" or c("panel", "global").\cr
Note that it only applies when display is seen as overlaying populations.}

\item{precision}{when graphs is a 2D scatter with population overlay, this argument controls amount of information displayed. Default is "light".\cr
-"light", the default, will only display points of same coordinates that are among the other layers.\cr
-"full" will display all the layers.}

\item{trunc_labels}{maximum number of characters to display for labels. Default is 38.}

\item{trans}{transformation function for density graphs. If missing the default, the BasePop[[1]]$densitytrans, if any, will be retrieved, otherwise asinh will be used.}

\item{bin}{number of bin used for histogram / density. Default is missing.}

\item{viewport}{either "ideas", "data" or "max" defining limits used for the graph. Default is "ideas".\cr
-"ideas" will use same limits as the one defined in ideas.\cr
-"data" will use data to define limits.\cr
-"max" will use data and regions drawn to define limits.}

\item{...}{other arguments to be passed.}
}
\value{
it invisibly returns a list whose members are:\cr
-plot, "trellis" object that can be displayed using plot,\cr
-stats, a table of statistics computed for the graph,\cr
-input, a list with input parameters.
}
\description{
Computes plot and stats from a IFC graph
}
