% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp_raster}
\alias{cpp_raster}
\title{Raster Image}
\arguments{
\item{width}{a uint16_t determining the returned image width.}

\item{height}{a uint16_t determining the returned image height.}

\item{obj}{a List containing drawing information:\cr
- pch, an integer specifying a symbol to draw. Handled are [0-20]. Otherwise only a pixel will be drawn.\cr
- size, an integer specifying the size in pixel of the shape, from 1 to 255.\cr
- color a 4 rows IntegerMatrix (rgba) of the color used to draw the shape.\cr
- coords, an IntegerMatrix whose rows are points to draw and with:\cr
-* 1st column being img col coordinate in px,\cr
-* 2nd column being img row coordinate in px.
- blur_size an integer controlling the size of the blurring gaussian kernel.\cr
- blur_sd a double controlling the sd of the blurring gaussian kernel.}

\item{bg_}{a Nullable IntegerVector that will be cast to 3D array when not NULL. Default is R_NilValue.\cr
When not NULL, its dimensions should be the same as required by 'width' and 'height', otherwise an error will be thrown.\cr
When not NULL, it will serve as a background to draw new points on top of it.}
}
\value{
an IntegerVector with dimensions [height, width, 4]
}
\description{
low-level function to create plot raster
}
\details{
shape according to 'pch' will be drawn centered at coordinates obj$coord[, 1], obj$coord[, 0]
and every pixels being part of the shape will be filled with 'color'.
If only one 'color' is provided, this 'color' will be used for each points.
If more than one 'color' is provided, then if number of colors (ncol) equals the number of points 'color' will be used as is for each single point.
Otherwise, 'color' will be considered as a color-gradient and density will be computed.
/!\ please note that IFC:::densCols() is faster to compute color based on density for n < 20000 points, so it's worth using it when number of points are lower.
}
\keyword{internal}
